/*
 * Decompiled with CFR 0.152.
 */
package cdc.util.data.paths;

import cdc.util.data.Element;
import cdc.util.data.Parent;
import cdc.util.lang.Checks;
import cdc.util.lang.CollectionsUtil;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class SPath {
    private final List<String> parts;
    private final boolean isAttribute;

    public SPath(String text) {
        int index = text.lastIndexOf(64);
        boolean bl = this.isAttribute = index >= 0;
        Object[] tmp = index == 0 ? new String[]{} : (index > 0 ? text.substring(0, index).split("/") : text.split("/"));
        List l = CollectionsUtil.toList((Object[])tmp);
        if (this.isAttribute) {
            String last = text.substring(index + 1);
            Checks.isFalse((boolean)last.contains("/"), (String)"An attribute name can not contain '/'");
            l.add(last);
        }
        this.parts = Collections.unmodifiableList(l);
    }

    public List<String> getParts() {
        return this.parts;
    }

    public boolean isAttribute() {
        return this.isAttribute;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        int size = this.parts.size();
        int index = 0;
        while (index < size) {
            if (index > 0) {
                if (index == size - 1 && this.isAttribute) {
                    builder.append('/');
                } else {
                    builder.append('@');
                }
            }
            builder.append(this.parts.get(index));
            ++index;
        }
        return builder.toString();
    }

    private boolean matches(Parent parent, String name, boolean attribute) {
        if (attribute != this.isAttribute || this.parts.isEmpty()) {
            return false;
        }
        if (Objects.equals(name, this.parts.get(this.parts.size() - 1))) {
            Parent p = parent;
            int index = this.parts.size() - 2;
            while (index > 0) {
                Element e;
                if (p instanceof Element) {
                    e = (Element)p;
                    if (!e.getName().equals(this.parts.get(index))) {
                        return false;
                    }
                } else {
                    return false;
                }
                p = e.getParent();
                --index;
            }
            return true;
        }
        return false;
    }

    public boolean matchesElement(Parent parent) {
        if (parent instanceof Element) {
            Element element = (Element)parent;
            return this.matchesElement(element.getParent(), element.getName());
        }
        return false;
    }

    public boolean matchesElement(Parent parent, String name) {
        return this.matches(parent, name, false);
    }

    public boolean matchesAttribute(Element parent, String name) {
        return this.matches(parent, name, true);
    }
}

