/*
 * Decompiled with CFR 0.152.
 */
package cdc.util.data.tools;

import cdc.util.cli.AbstractMainSupport;
import cdc.util.data.Attribute;
import cdc.util.data.Element;
import cdc.util.data.paths.SPath;
import cdc.util.data.xml.XmlDataReader;
import cdc.util.lang.CollectionsUtil;
import cdc.util.lang.FailureReaction;
import cdc.util.refs.LazyClassRef;
import cdc.util.refs.ResolutionStatus;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class XmlCheckClassRefs {
    protected static final Logger LOGGER = LogManager.getLogger(XmlCheckClassRefs.class);
    private final MainArgs margs;
    private final Set<String> classes = new HashSet<String>();
    private final Map<String, Boolean> done = new HashMap<String, Boolean>();

    private XmlCheckClassRefs(MainArgs margs) {
        this.margs = margs;
    }

    private void execute() throws IOException {
        for (File jar : this.margs.jarFiles) {
            LOGGER.info("Analyze jar '" + jar + "'");
            this.listJarClasseNames(jar);
        }
        for (File file : this.margs.input) {
            LOGGER.info("Analyze xml '" + file + "'");
            Element root = XmlDataReader.loadRoot(file, new XmlDataReader.Feature[0]);
            this.analyze(file, root);
        }
        LOGGER.info("Valid classes");
        for (String className : CollectionsUtil.toSortedList(this.done.keySet())) {
            boolean success = this.done.get(className);
            if (!success) continue;
            LOGGER.info("   " + className);
        }
        LOGGER.info("Invalid classes");
        for (String className : CollectionsUtil.toSortedList(this.done.keySet())) {
            boolean success = this.done.get(className);
            if (success) continue;
            LOGGER.info("   " + className);
        }
    }

    private void listJarClasseNames(File jar) {
        LOGGER.debug("listJarClasseNames(" + jar + ")");
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (ZipFile archive = new ZipFile(jar);){
                Enumeration<? extends ZipEntry> iter = archive.entries();
                while (iter.hasMoreElements()) {
                    ZipEntry entry = iter.nextElement();
                    String name = entry.getName();
                    if (!name.endsWith(".class")) continue;
                    String className = name.substring(0, name.length() - 6).replaceAll("/", ".");
                    LOGGER.debug("   " + className);
                    this.classes.add(className);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            LOGGER.catching((Throwable)e);
        }
    }

    private void analyze(File file, Element element) {
        for (SPath path : this.margs.paths) {
            if (path.matchesElement(element)) {
                String s = element.getText(null);
                this.checkClassName(s, file, element.getQName());
            }
            for (Attribute att : element.getAttributes()) {
                if (!path.matchesAttribute(element, att.getName())) continue;
                String s = att.getValue();
                this.checkClassName(s, file, String.valueOf(element.getQName()) + "/@" + att.getName());
            }
        }
        for (Element child : element.getElements()) {
            this.analyze(file, child);
        }
    }

    private void checkClassName(String className, File file, String location) {
        LOGGER.debug("checkClassName(" + className + ", " + location + ")");
        Boolean success = this.done.get(className);
        if (success == null) {
            success = this.resolve(className);
            this.done.put(className, success);
        }
        if (success.booleanValue()) {
            LOGGER.info(file + ": " + location + ": " + className + ": valid class name");
        } else {
            LOGGER.info(file + ": " + location + ": " + className + ": invalid class name");
        }
    }

    private boolean resolve(String className) {
        if (this.classes.contains(className)) {
            return true;
        }
        LazyClassRef ref = new LazyClassRef(className);
        ref.resolve(FailureReaction.DEFAULT);
        return ref.getResolutionStatus() == ResolutionStatus.SUCCESS;
    }

    public static void execute(MainArgs margs) throws IOException {
        XmlCheckClassRefs instance = new XmlCheckClassRefs(margs);
        instance.execute();
    }

    public static void main(String[] args) {
        MainSupport support = new MainSupport();
        support.main(args);
    }

    public static class MainArgs {
        public final List<File> input = new ArrayList<File>();
        public final Set<SPath> paths = new HashSet<SPath>();
        public final List<File> jarFiles = new ArrayList<File>();
    }

    private static class MainSupport
    extends AbstractMainSupport<MainArgs, Void> {
        private static final String JAR_FILE = "jar";

        public MainSupport() {
            super(XmlCheckClassRefs.class, LOGGER);
        }

        protected String getVersion() {
            return "0.0.17";
        }

        protected void addSpecificOptions(Options options) {
            options.addOption(Option.builder().longOpt("input").desc("XML input URL(s).").hasArgs().required().build());
            options.addOption(Option.builder().longOpt(JAR_FILE).desc("Jar file(s) where classes must be searched, in addition to classes that can be accessed with class path.").hasArgs().build());
            options.addOption(Option.builder().longOpt("path").desc("Path(s) of attributes and elements to analyze in input files.\nThey must match elt-name(/elt-name)* or (elt-name(/elt-name)*)@att-name.\nExamples: foo, foo1/foo2, @bar, foo@bar, foo1/foo2@bar").hasArgs().required().build());
        }

        protected MainArgs analyze(CommandLine cl) throws ParseException {
            String s;
            int n;
            int n2;
            String[] stringArray;
            MainArgs margs = new MainArgs();
            if (cl.getOptionValues(JAR_FILE) != null) {
                stringArray = cl.getOptionValues(JAR_FILE);
                n2 = stringArray.length;
                n = 0;
                while (n < n2) {
                    s = stringArray[n];
                    margs.jarFiles.add(new File(s));
                    ++n;
                }
            }
            if (cl.getOptionValues("input") != null) {
                stringArray = cl.getOptionValues("input");
                n2 = stringArray.length;
                n = 0;
                while (n < n2) {
                    s = stringArray[n];
                    margs.input.add(new File(s));
                    ++n;
                }
            }
            if (cl.hasOption("path")) {
                stringArray = cl.getOptionValues("path");
                n2 = stringArray.length;
                n = 0;
                while (n < n2) {
                    s = stringArray[n];
                    margs.paths.add(new SPath(s));
                    ++n;
                }
            }
            return margs;
        }

        protected Void execute(MainArgs margs) throws Exception {
            XmlCheckClassRefs.execute(margs);
            return null;
        }
    }
}

