/*
 * Decompiled with CFR 0.152.
 */
package cdc.util.data.util;

import cdc.util.data.Element;
import cdc.util.data.paths.SPath;
import cdc.util.lang.Checks;
import java.util.Map;
import java.util.function.Function;

@FunctionalInterface
public interface AttributeNameConverter {
    public static final AttributeNameConverter IDENTITY = (e, n) -> n;

    public String convertAttributeName(Element var1, String var2);

    default public AttributeNameConverter compose(AttributeNameConverter other) {
        Checks.isNotNull((Object)other, (String)"other");
        return (element, name) -> this.convertAttributeName(element, other.convertAttributeName(element, name));
    }

    default public AttributeNameConverter andThen(AttributeNameConverter other) {
        Checks.isNotNull((Object)other, (String)"other");
        return (element, name) -> other.convertAttributeName(element, this.convertAttributeName(element, name));
    }

    public static AttributeNameConverter fromNameFunction(Function<String, String> function) {
        Checks.isNotNull(function, (String)"function");
        return (element, name) -> (String)function.apply(name);
    }

    public static AttributeNameConverter fromNameMap(Map<String, String> map) {
        Checks.isNotNull(map, (String)"map");
        return (element, name) -> map.getOrDefault(name, name);
    }

    public static AttributeNameConverter fromPathMap(Map<SPath, String> map) {
        Checks.isNotNull(map, (String)"map");
        return (element, name) -> {
            for (Map.Entry entry : map.entrySet()) {
                if (!((SPath)entry.getKey()).matchesAttribute(element, name)) continue;
                return (String)entry.getValue();
            }
            return name;
        };
    }
}

