/*
 * Decompiled with CFR 0.152.
 */
package cdc.util.data.util;

import cdc.util.data.Element;
import cdc.util.data.paths.SPath;
import cdc.util.lang.Checks;
import cdc.util.strings.StringUtil;
import java.util.Map;
import java.util.function.Function;

@FunctionalInterface
public interface AttributeValueConverter {
    public static final AttributeValueConverter INDENTITY = (e, n, v) -> v;

    public String convertAttributeValue(Element var1, String var2, String var3);

    default public AttributeValueConverter compose(AttributeValueConverter other) {
        Checks.isNotNull((Object)other, (String)"other");
        return (element, name, value) -> this.convertAttributeValue(element, name, other.convertAttributeValue(element, name, value));
    }

    default public AttributeValueConverter andThen(AttributeValueConverter other) {
        Checks.isNotNull((Object)other, (String)"other");
        return (element, name, value) -> other.convertAttributeValue(element, name, this.convertAttributeValue(element, name, value));
    }

    public static AttributeValueConverter fromString(String s) {
        return (element, name, value) -> s;
    }

    public static AttributeValueConverter scramble(boolean preserveSpaces) {
        return (element, name, value) -> StringUtil.scrambleWithLettersOrDigits((String)value, (boolean)preserveSpaces);
    }

    public static AttributeValueConverter fromValueFunction(Function<String, String> function) {
        Checks.isNotNull(function, (String)"function");
        return (element, name, value) -> (String)function.apply(value);
    }

    public static AttributeValueConverter fromValueMap(Map<String, String> map) {
        Checks.isNotNull(map, (String)"map");
        return (element, name, value) -> map.getOrDefault(value, value);
    }

    public static AttributeValueConverter fromNameMap(Map<String, String> map) {
        Checks.isNotNull(map, (String)"map");
        return (element, name, value) -> map.getOrDefault(name, value);
    }

    public static AttributeValueConverter fromPathMap(Map<SPath, String> map) {
        Checks.isNotNull(map, (String)"map");
        return (element, name, value) -> {
            for (Map.Entry entry : map.entrySet()) {
                if (!((SPath)entry.getKey()).matchesAttribute(element, name)) continue;
                return (String)entry.getValue();
            }
            return value;
        };
    }
}

