/*
 * Decompiled with CFR 0.152.
 */
package cdc.util.data.util;

import cdc.util.data.Comment;
import cdc.util.data.Element;
import cdc.util.data.Node;
import cdc.util.data.Parent;
import cdc.util.data.Text;
import java.io.PrintStream;

public final class DataDebug {
    private DataDebug() {
    }

    private static void indent(PrintStream out, int level) {
        int i = 0;
        while (i < level) {
            out.print("  ");
            ++i;
        }
    }

    public static void print(Node node, Node highlight1, Node highlight2, int level, PrintStream out) {
        DataDebug.indent(out, level);
        out.print((Object)node.getType());
        if (node == highlight1) {
            out.print(" *");
        }
        if (node == highlight2) {
            out.print(" +");
        }
        switch (node.getType()) {
            case COMMENT: {
                Comment comment = (Comment)node;
                out.print(" " + comment.getContent().length());
                break;
            }
            case DOCUMENT: {
                break;
            }
            case ELEMENT: {
                Element element = (Element)node;
                out.print(" " + element.getName());
                break;
            }
            case TEXT: {
                Text text = (Text)node;
                out.print(" " + text.getContent().length());
                break;
            }
        }
        out.println();
        if (node instanceof Parent) {
            for (Node node2 : ((Parent)node).getChildren()) {
                DataDebug.print(node2, highlight1, highlight2, level + 1, out);
            }
        }
    }

    public static void print(Node node, int level, PrintStream out) {
        DataDebug.print(node, null, null, level, out);
    }
}

