/*
 * Decompiled with CFR 0.152.
 */
package cdc.util.data.util;

import cdc.util.data.Parent;
import cdc.util.data.paths.SPath;
import cdc.util.lang.Checks;
import java.util.Map;
import java.util.function.Function;

@FunctionalInterface
public interface ElementNameConverter {
    public static final ElementNameConverter IDENTITY = (p, n) -> n;

    public String convertElementName(Parent var1, String var2);

    default public ElementNameConverter compose(ElementNameConverter other) {
        Checks.isNotNull((Object)other, (String)"other");
        return (parent, name) -> this.convertElementName(parent, other.convertElementName(parent, name));
    }

    default public ElementNameConverter andThen(ElementNameConverter other) {
        Checks.isNotNull((Object)other, (String)"other");
        return (parent, name) -> other.convertElementName(parent, this.convertElementName(parent, name));
    }

    public static ElementNameConverter fromNameFunction(Function<String, String> function) {
        Checks.isNotNull(function, (String)"function");
        return (parent, name) -> (String)function.apply(name);
    }

    public static ElementNameConverter fromNameMap(Map<String, String> map) {
        Checks.isNotNull(map, (String)"map");
        return (parent, name) -> map.getOrDefault(name, name);
    }

    public static ElementNameConverter fromPathMap(Map<SPath, String> map) {
        Checks.isNotNull(map, (String)"map");
        return (parent, name) -> {
            for (Map.Entry entry : map.entrySet()) {
                if (!((SPath)entry.getKey()).matchesElement(parent, name)) continue;
                return (String)entry.getValue();
            }
            return name;
        };
    }
}

