/*
 * Decompiled with CFR 0.152.
 */
package cdc.util.data.util;

import cdc.util.data.Element;
import cdc.util.data.Parent;
import cdc.util.data.Text;
import cdc.util.data.paths.SPath;
import cdc.util.lang.Checks;
import java.util.Collection;

@FunctionalInterface
public interface TextPredicate {
    public static final TextPredicate ANY_TEXT = (parent, text) -> true;
    public static final TextPredicate IGNORABLE_TEXT = (parent, text) -> text.isIgnorable();
    public static final TextPredicate NON_IGNORABLE_TEXT = (parent, text) -> !text.isIgnorable();

    public boolean accepts(Parent var1, Text var2);

    default public TextPredicate not() {
        return (p, t) -> !this.accepts(p, t);
    }

    default public TextPredicate and(TextPredicate other) {
        Checks.isNotNull((Object)other, (String)"other");
        return (p, t) -> this.accepts(p, t) && other.accepts(p, t);
    }

    default public TextPredicate or(TextPredicate other) {
        Checks.isNotNull((Object)other, (String)"other");
        return (p, t) -> this.accepts(p, t) || other.accepts(p, t);
    }

    public static TextPredicate fromElementNames(Collection<String> names) {
        Checks.isNotNull(names, (String)"names");
        return (parent, text) -> {
            if (parent instanceof Element) {
                return names.contains(((Element)parent).getName());
            }
            return false;
        };
    }

    public static TextPredicate fromElementPaths(Collection<SPath> paths) {
        Checks.isNotNull(paths, (String)"paths");
        return (parent, text) -> {
            for (SPath path : paths) {
                if (!path.matchesElement(parent)) continue;
                return true;
            }
            return false;
        };
    }
}

