/*
 * Decompiled with CFR 0.152.
 */
package cdc.test.util.data;

import cdc.util.data.Child;
import cdc.util.data.Document;
import cdc.util.data.Element;
import cdc.util.data.Node;
import cdc.util.data.NodeType;
import cdc.util.data.Parent;
import cdc.util.data.Text;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TextTest {
    private static final String HELLO = "Hello";
    private static final String NAME = "name";

    @Test
    public void testConstructors1() {
        Text x = new Text();
        Assertions.assertEquals((Object)NodeType.TEXT, (Object)x.getType());
        Assertions.assertEquals(null, (Object)x.getParent());
        Assertions.assertEquals((Object)"", (Object)x.getContent());
        x.setContent(HELLO);
        Assertions.assertEquals((Object)HELLO, (Object)x.getContent());
        x.clearContent();
        Assertions.assertEquals((Object)"", (Object)x.getContent());
        x.appendContent(HELLO);
        Assertions.assertEquals((Object)HELLO, (Object)x.getContent());
        x.appendContent(null);
        Assertions.assertEquals((Object)HELLO, (Object)x.getContent());
        Assertions.assertEquals(null, (Object)x.getRootElement());
        Assertions.assertEquals(null, (Object)x.getDocument());
        Assertions.assertEquals((Object)x, (Object)x.getRootChild());
        Assertions.assertTrue((boolean)x.deepEquals((Node)x));
        Assertions.assertFalse((boolean)x.deepEquals(null));
    }

    @Test
    public void testConstructors2() {
        Document doc = new Document();
        Text x = new Text((Parent)doc);
        Assertions.assertEquals((Object)NodeType.TEXT, (Object)x.getType());
        Assertions.assertEquals((Object)doc, (Object)x.getParent());
        Assertions.assertEquals((Object)"", (Object)x.getContent());
        x.setContent(HELLO);
        Assertions.assertEquals((Object)HELLO, (Object)x.getContent());
        x.clearContent();
        Assertions.assertEquals((Object)"", (Object)x.getContent());
        x.appendContent(HELLO);
        Assertions.assertEquals((Object)HELLO, (Object)x.getContent());
        x.appendContent(null);
        Assertions.assertEquals((Object)HELLO, (Object)x.getContent());
        Assertions.assertEquals(null, (Object)x.getRootElement());
        Assertions.assertEquals((Object)doc, (Object)x.getDocument());
        Assertions.assertEquals((Object)x, (Object)x.getRootChild());
    }

    @Test
    public void testClone() {
        Text x1 = new Text(null, HELLO);
        Text x2 = x1.clone(false);
        Text x3 = x1.clone(true);
        Assertions.assertNotEquals((Object)x1, (Object)x2);
        Assertions.assertNotEquals((Object)x1, (Object)x3);
        Assertions.assertTrue((boolean)x1.deepEquals((Node)x2));
        Assertions.assertTrue((boolean)x2.deepEquals((Node)x1));
    }

    @Test
    public void testIsIgnorableWhiteSpace() {
        Text x = new Text();
        Assertions.assertTrue((boolean)x.isIgnorable());
        x.setContent(" ");
        Assertions.assertTrue((boolean)x.isIgnorable());
        x.setContent("\t");
        Assertions.assertTrue((boolean)x.isIgnorable());
        x.setContent("\n");
        Assertions.assertTrue((boolean)x.isIgnorable());
        x.setContent("\r");
        Assertions.assertTrue((boolean)x.isIgnorable());
        x.setContent("a");
        Assertions.assertFalse((boolean)x.isIgnorable());
    }

    @Test
    public void testGetRootElement() {
        Text x = new Text(HELLO);
        Assertions.assertEquals(null, (Object)x.getRootElement());
        Element root = new Element(NAME);
        root.addChild((Child)x);
        Assertions.assertEquals((Object)root, (Object)x.getRootElement());
    }
}

