/*
 * Decompiled with CFR 0.152.
 */
package cdc.test.util.data;

import cdc.util.data.paths.SPath;
import cdc.util.data.tools.XmlNormalizer;
import cdc.util.files.Files;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class XmlNormalizerTest {
    private static final Logger LOGGER = LogManager.getLogger(XmlNormalizerTest.class);
    private static final String XML = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    private static final String INDENT = "";
    private static final String EOL = "";

    private static void test(String expected, String source, boolean delayedProcessing, Consumer<XmlNormalizer.MainArgs> margsSetter) throws IOException {
        LOGGER.debug("expected:" + expected);
        LOGGER.debug("source:" + source);
        File input = File.createTempFile(XmlNormalizerTest.class.getSimpleName(), ".in");
        input.deleteOnExit();
        File output = File.createTempFile(XmlNormalizerTest.class.getSimpleName(), ".out");
        output.deleteOnExit();
        XmlNormalizer.MainArgs margs = new XmlNormalizer.MainArgs();
        margs.inputFile = input;
        margs.outputFile = output;
        margs.indentString = "";
        margs.setEnabled(XmlNormalizer.MainArgs.Feature.PRETTY_PRINT, false);
        margs.setEnabled(XmlNormalizer.MainArgs.Feature.DELAYED_PROCESSING, delayedProcessing);
        margsSetter.accept(margs);
        try (FileWriter writer = new FileWriter(input);){
            writer.write(source);
            writer.flush();
        }
        XmlNormalizer.execute((XmlNormalizer.MainArgs)margs);
        Files.cat((File)input, (Charset)StandardCharsets.UTF_8, (Logger)LOGGER, (Level)Level.DEBUG);
        Files.cat((File)output, (Charset)StandardCharsets.UTF_8, (Logger)LOGGER, (Level)Level.DEBUG);
        String result = Files.readFileAsString((File)output, (Charset)StandardCharsets.UTF_8);
        Assertions.assertEquals((Object)expected, (Object)result);
    }

    private static void test(String expected, String source, Consumer<XmlNormalizer.MainArgs> margsSetter) throws IOException {
        XmlNormalizerTest.test(expected, source, true, margsSetter);
        XmlNormalizerTest.test(expected, source, false, margsSetter);
    }

    @Test
    public void testBasic() throws IOException {
        String source = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><root><child/></root>";
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><root><child/></root>";
        XmlNormalizerTest.test("<?xml version=\"1.0\" encoding=\"UTF-8\"?><root><child/></root>", "<?xml version=\"1.0\" encoding=\"UTF-8\"?><root><child/></root>", margs -> {});
    }

    @Test
    public void testRemove() throws IOException {
        String source = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><root att=''><child/></root>";
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><root/>";
        XmlNormalizerTest.test("<?xml version=\"1.0\" encoding=\"UTF-8\"?><root/>", "<?xml version=\"1.0\" encoding=\"UTF-8\"?><root att=''><child/></root>", margs -> {
            margs.removed.add(new SPath("root/child"));
            margs.removed.add(new SPath("root@att"));
        });
    }

    @Test
    public void testRemoveEmptyAttributes() throws IOException {
        String source = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><root><child att=''/></root>";
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><root><child/></root>";
        XmlNormalizerTest.test("<?xml version=\"1.0\" encoding=\"UTF-8\"?><root><child/></root>", "<?xml version=\"1.0\" encoding=\"UTF-8\"?><root><child att=''/></root>", margs -> margs.setEnabled(XmlNormalizer.MainArgs.Feature.REMOVE_EMPTY_ATTRIBUTES, true));
    }

    @Test
    public void testRemovePureElements() throws IOException {
        String source = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><root att=''><child/></root>";
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><root att=\"\"/>";
        XmlNormalizerTest.test("<?xml version=\"1.0\" encoding=\"UTF-8\"?><root att=\"\"/>", "<?xml version=\"1.0\" encoding=\"UTF-8\"?><root att=''><child/></root>", margs -> margs.setEnabled(XmlNormalizer.MainArgs.Feature.REMOVE_PURE_ELEMENTS, true));
    }

    @Test
    public void testRename() throws IOException {
        String source = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><root><child att1='' att2=''/></root>";
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><root><CHILD ATT1=\"\" att2=\"\"/></root>";
        XmlNormalizerTest.test("<?xml version=\"1.0\" encoding=\"UTF-8\"?><root><CHILD ATT1=\"\" att2=\"\"/></root>", "<?xml version=\"1.0\" encoding=\"UTF-8\"?><root><child att1='' att2=''/></root>", margs -> {
            margs.renamed.put(new SPath("root/child"), "CHILD");
            margs.renamed.put(new SPath("child@att1"), "ATT1");
        });
    }

    @Test
    public void testSetAttributesValues() throws IOException {
        String source = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><root><child att='value'/></root>";
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><root><child att=\"VALUE\"/></root>";
        XmlNormalizerTest.test("<?xml version=\"1.0\" encoding=\"UTF-8\"?><root><child att=\"VALUE\"/></root>", "<?xml version=\"1.0\" encoding=\"UTF-8\"?><root><child att='value'/></root>", margs -> margs.set.put(new SPath("@att"), "VALUE"));
    }

    @Test
    public void testSetElementsContents1() throws IOException {
        String source = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><root><child>a</child></root>";
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><root><child>CONTENT</child></root>";
        XmlNormalizerTest.test("<?xml version=\"1.0\" encoding=\"UTF-8\"?><root><child>CONTENT</child></root>", "<?xml version=\"1.0\" encoding=\"UTF-8\"?><root><child>a</child></root>", margs -> margs.set.put(new SPath("child"), "CONTENT"));
    }

    @Test
    public void testSetElementsContents2() throws IOException {
        String source = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><root><child/></root>";
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><root><child>CONTENT</child></root>";
        XmlNormalizerTest.test("<?xml version=\"1.0\" encoding=\"UTF-8\"?><root><child>CONTENT</child></root>", "<?xml version=\"1.0\" encoding=\"UTF-8\"?><root><child/></root>", margs -> margs.set.put(new SPath("child"), "CONTENT"));
    }

    @Test
    public void testSortAttributes() throws IOException {
        String source = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><root><child att2='' att1=''/></root>";
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><root><child att1=\"\" att2=\"\"/></root>";
        XmlNormalizerTest.test("<?xml version=\"1.0\" encoding=\"UTF-8\"?><root><child att1=\"\" att2=\"\"/></root>", "<?xml version=\"1.0\" encoding=\"UTF-8\"?><root><child att2='' att1=''/></root>", margs -> margs.setEnabled(XmlNormalizer.MainArgs.Feature.SORT_ATTRIBUTES, true));
    }

    @Test
    public void testSortElements() throws IOException {
        String source = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><root><child3/><child2/><child1/></root>";
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><root><child1/><child2/><child3/></root>";
        XmlNormalizerTest.test("<?xml version=\"1.0\" encoding=\"UTF-8\"?><root><child1/><child2/><child3/></root>", "<?xml version=\"1.0\" encoding=\"UTF-8\"?><root><child3/><child2/><child1/></root>", margs -> margs.setEnabled(XmlNormalizer.MainArgs.Feature.SORT_ELEMENTS, true));
    }

    @Test
    public void testMoveAttributeFirst() throws IOException {
        String source = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><root><child att3='' att2='' att1=''/></root>";
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><root><child att1=\"\" att3=\"\" att2=\"\"/></root>";
        XmlNormalizerTest.test("<?xml version=\"1.0\" encoding=\"UTF-8\"?><root><child att1=\"\" att3=\"\" att2=\"\"/></root>", "<?xml version=\"1.0\" encoding=\"UTF-8\"?><root><child att3='' att2='' att1=''/></root>", margs -> margs.firstAttributes.add("att1"));
    }

    @Test
    public void testUseSingleQuote() throws IOException {
        String source = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><root><child att3='' att2='' att1=''/></root>";
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><root><child att3='' att2='' att1=''/></root>";
        XmlNormalizerTest.test("<?xml version=\"1.0\" encoding=\"UTF-8\"?><root><child att3='' att2='' att1=''/></root>", "<?xml version=\"1.0\" encoding=\"UTF-8\"?><root><child att3='' att2='' att1=''/></root>", margs -> margs.setEnabled(XmlNormalizer.MainArgs.Feature.USE_SINGLE_QUOTE, true));
    }

    @Test
    public void testAlwaysEntitizeAttributes() throws IOException {
        String source = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><root><child att='&#x9;'/></root>";
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><root><child att=\"&#x9;\"/></root>";
        XmlNormalizerTest.test("<?xml version=\"1.0\" encoding=\"UTF-8\"?><root><child att=\"&#x9;\"/></root>", "<?xml version=\"1.0\" encoding=\"UTF-8\"?><root><child att='&#x9;'/></root>", margs -> margs.setEnabled(XmlNormalizer.MainArgs.Feature.ALWAYS_ENTITIZE_ATTRIBUTES, true));
    }
}

