package cdc.test.util.data;

import static org.junit.jupiter.api.Assertions.assertEquals;

import java.util.List;

import org.junit.jupiter.api.Test;

import cdc.util.data.paths.SPath;
import cdc.util.lang.CollectionUtils;

public class SPathTest {

    private static void test(String text,
                             List<String> expectedParts,
                             boolean expectedAttribute) {
        final SPath path = new SPath(text);
        assertEquals(expectedAttribute, path.isAttribute());
        assertEquals(expectedParts, path.getParts());
    }

    @Test
    public void testConstructor() {
        test("hello", CollectionUtils.toList("hello"), false);
        test("hello/world", CollectionUtils.toList("hello", "world"), false);
        test("hello/world/how", CollectionUtils.toList("hello", "world", "how"), false);
        test("@hello", CollectionUtils.toList("hello"), true);
        test("hello@world", CollectionUtils.toList("hello", "world"), true);
        test("hello/world@how", CollectionUtils.toList("hello", "world", "how"), true);
    }
}