/*
 * Decompiled with CFR 0.152.
 */
package cdc.test.util.data;

import cdc.util.data.Attribute;
import org.junit.Assert;
import org.junit.Test;

public class AttributeTest {
    private static final String NAME = "name";

    @Test
    public void testMisc() {
        Attribute att = new Attribute(NAME);
        Assert.assertEquals((Object)att, (Object)att);
        Assert.assertEquals((Object)NAME, (Object)att.getName());
        Attribute att2 = new Attribute(att);
        Assert.assertEquals((Object)att, (Object)att2);
        att2.setValue("XXX");
        Assert.assertNotEquals((Object)att, (Object)att2);
        Assert.assertNotEquals((Object)att, (Object)new Attribute("NAME"));
    }

    @Test
    public void testObject() {
        Attribute att1 = new Attribute(NAME, null);
        Assert.assertEquals(null, (Object)att1.getValue());
        Attribute att2 = new Attribute(NAME, this.getClass());
        Assert.assertEquals((Object)this.getClass().toString(), (Object)att2.getValue());
    }

    @Test
    public void testString() {
        Attribute att = new Attribute(NAME, "SSS");
        Assert.assertEquals((Object)"SSS", (Object)att.getValue());
    }

    @Test
    public void testBoolean() {
        Attribute att = new Attribute(NAME, true);
        Assert.assertTrue((boolean)att.getValueAsBoolean());
        Assert.assertEquals((Object)"true", (Object)att.getValue());
    }

    @Test
    public void testByte() {
        Attribute att = new Attribute(NAME, 10);
        Assert.assertEquals((long)10L, (long)att.getValueAsByte());
        Assert.assertEquals((Object)"10", (Object)att.getValue());
    }

    @Test
    public void testShort() {
        Attribute att = new Attribute(NAME, 10);
        Assert.assertEquals((long)10L, (long)att.getValueAsShort());
        Assert.assertEquals((Object)"10", (Object)att.getValue());
    }

    @Test
    public void testInteger() {
        Attribute att = new Attribute(NAME, 10);
        Assert.assertEquals((long)10L, (long)att.getValueAsInt());
        Assert.assertEquals((Object)"10", (Object)att.getValue());
    }

    @Test
    public void testLong() {
        Attribute att = new Attribute(NAME, 10L);
        Assert.assertEquals((long)10L, (long)att.getValueAsLong());
        Assert.assertEquals((Object)"10", (Object)att.getValue());
    }

    @Test
    public void testFloat() {
        Attribute att = new Attribute(NAME, 10.0f);
        Assert.assertEquals((double)10.0, (double)att.getValueAsFloat(), (double)1.0E-10);
        Assert.assertEquals((Object)"10.0", (Object)att.getValue());
    }

    @Test
    public void testDouble() {
        Attribute att = new Attribute(NAME, 10.0);
        Assert.assertEquals((double)10.0, (double)att.getValueAsDouble(), (double)1.0E-10);
        Assert.assertEquals((Object)"10.0", (Object)att.getValue());
    }

    @Test
    public void testEnum() {
        Attribute att = new Attribute(NAME, (java.lang.Enum)Enum.A);
        Assert.assertEquals((Object)((Object)Enum.A), (Object)att.getValueAsEnum(Enum.class));
        Assert.assertEquals((Object)Enum.A.name(), (Object)att.getValue());
    }

    private static enum Enum {
        A,
        B;

    }
}

