/*
 * Decompiled with CFR 0.152.
 */
package cdc.test.util.data;

import cdc.util.data.Child;
import cdc.util.data.Comment;
import cdc.util.data.Document;
import cdc.util.data.Element;
import cdc.util.data.Node;
import org.junit.Assert;
import org.junit.Test;

public class DocumentTest {
    private static final String NAME = "name";
    private static final String VALUE = "value";

    @Test
    public void testContructors() {
        Document doc = new Document();
        Assert.assertEquals((Object)doc, (Object)doc.getDocument());
        Assert.assertEquals(null, (Object)doc.getRootElement());
        Assert.assertEquals((long)0L, (long)doc.getChildrenCount());
        Assert.assertTrue((boolean)doc.deepEquals((Node)doc));
        Assert.assertEquals(null, (Object)doc.getLastChild());
    }

    @Test
    public void testDeepEquals() {
        Document doc1 = new Document();
        Document doc2 = new Document();
        Assert.assertTrue((boolean)doc1.deepEquals((Node)doc2));
        doc1.addChild((Child)new Comment());
        Assert.assertFalse((boolean)doc1.deepEquals((Node)doc2));
        doc2.addChild((Child)new Comment());
        Assert.assertTrue((boolean)doc1.deepEquals((Node)doc2));
        doc1.addChild((Child)new Element(NAME));
        Assert.assertFalse((boolean)doc1.deepEquals((Node)doc2));
        doc2.addChild((Child)new Element(NAME));
        Assert.assertTrue((boolean)doc1.deepEquals((Node)doc2));
        ((Element)doc1.getLastChild()).addAttribute(NAME, VALUE);
        Assert.assertFalse((boolean)doc1.deepEquals((Node)doc2));
        ((Element)doc2.getLastChild()).addAttribute(NAME, VALUE);
        Assert.assertTrue((boolean)doc1.deepEquals((Node)doc2));
        Document doc3 = doc1.clone(true);
        Assert.assertTrue((boolean)doc1.deepEquals((Node)doc3));
        doc3.removeChildren();
        Assert.assertEquals((long)0L, (long)doc3.getChildrenCount());
    }

    @Test
    public void testGetRootElement() {
        Assert.assertEquals(null, (Object)Document.getRootElement(null));
        Document doc = new Document();
        Assert.assertEquals(null, (Object)doc.getRootElement());
        Assert.assertEquals(null, (Object)Document.getRootElement((Document)doc));
        Element root = new Element(NAME);
        doc.addChild((Child)root);
        Assert.assertEquals((Object)root, (Object)doc.getRootElement());
        Assert.assertEquals((Object)root, (Object)doc.getRootElement());
        Assert.assertEquals((Object)root, (Object)Document.getRootElement((Document)doc));
    }

    @Test
    public void testCanAddChild() {
        Document doc = new Document();
        Assert.assertFalse((boolean)doc.canAddChild(null));
        Element root = doc.addElement("root");
        Assert.assertFalse((boolean)doc.canAddChild((Child)root));
    }

    @Test
    public void testRoot() {
        Document doc = new Document();
        Assert.assertEquals(null, (Object)doc.getRootElement());
        Element root = new Element("root");
        Assert.assertEquals(null, (Object)root.getParent());
        Assert.assertTrue((boolean)doc.canAddChild((Child)root));
        doc.addChild((Child)root);
        Assert.assertFalse((boolean)doc.canAddChild((Child)root));
        Assert.assertEquals((Object)root, (Object)doc.getRootElement());
        root.setParent(null);
        Assert.assertEquals(null, (Object)root.getParent());
        Assert.assertEquals(null, (Object)doc.getRootElement());
    }
}

