/*
 * Decompiled with CFR 0.152.
 */
package cdc.test.util.data;

import cdc.util.data.Child;
import cdc.util.data.Comment;
import cdc.util.data.Element;
import cdc.util.data.ElementContentType;
import cdc.util.data.Leaf;
import cdc.util.data.Node;
import cdc.util.data.Parent;
import cdc.util.data.Text;
import cdc.util.lang.FailureReaction;
import org.junit.Assert;
import org.junit.Test;

public class ElementTest {
    private static final String NAME = "name";
    private static final String NAME1 = "name1";
    private static final String NAME2 = "name2";
    private static final String VALUE = "value";

    @Test
    public void testConstructors() {
        Element e = new Element(NAME);
        Assert.assertEquals(null, (Object)e.getParent());
        Assert.assertEquals((Object)ElementContentType.EMPTY, (Object)e.getContentType());
        e.addComment("comment", true);
        Assert.assertEquals((Object)ElementContentType.NON_TEXT, (Object)e.getContentType());
    }

    @Test
    public void testClone() {
        Element e1 = new Element(NAME);
        e1.addAttribute(NAME1, VALUE);
        e1.addAttribute(NAME2, VALUE);
        Element e2 = e1.clone(true);
        Assert.assertTrue((boolean)e1.deepEquals((Node)e2));
    }

    @Test
    public void testDeepEquals() {
        Element e1 = new Element(NAME);
        e1.addAttribute(NAME1, VALUE);
        e1.addAttribute(NAME2, VALUE);
        Element e2 = new Element(NAME);
        e2.addAttribute(NAME2, VALUE);
        e2.addAttribute(NAME1, VALUE);
        Assert.assertTrue((boolean)e1.deepEquals((Node)e2));
    }

    @Test
    public void testContentType() {
        Element e = new Element(NAME);
        Assert.assertEquals((Object)ElementContentType.EMPTY, (Object)e.getContentType());
        e.addComment("Hello");
        Assert.assertEquals((Object)ElementContentType.NON_TEXT, (Object)e.getContentType());
        e.removeChildren();
        Assert.assertEquals((Object)ElementContentType.EMPTY, (Object)e.getContentType());
        e.addText("Hello");
        Assert.assertEquals((Object)ElementContentType.TEXT, (Object)e.getContentType());
        e.addText("World");
        Assert.assertEquals((Object)ElementContentType.TEXT, (Object)e.getContentType());
        e.addComment("Hello");
        Assert.assertEquals((Object)ElementContentType.MIXED, (Object)e.getContentType());
        e.removeChildren();
        Assert.assertEquals((Object)ElementContentType.EMPTY, (Object)e.getContentType());
        e.addElement("child");
        Assert.assertEquals((Object)ElementContentType.NON_TEXT, (Object)e.getContentType());
        e.addComment("Hello");
        Assert.assertEquals((Object)ElementContentType.NON_TEXT, (Object)e.getContentType());
        e.addText("World");
        Assert.assertEquals((Object)ElementContentType.MIXED, (Object)e.getContentType());
    }

    @Test
    public void testAttributes() {
        Element e = new Element(NAME);
        Assert.assertEquals((long)0L, (long)e.getAttributesCount());
        Assert.assertFalse((boolean)e.hasAttribute(NAME1));
        Assert.assertEquals((long)-1L, (long)e.getAttributeIndex(NAME1));
        Assert.assertTrue((boolean)e.getAttributes().isEmpty());
        Assert.assertEquals(null, (Object)e.getAttributeValue(NAME1));
        e.addAttribute(NAME1, null);
        Assert.assertTrue((boolean)e.hasAttribute(NAME1));
        Assert.assertEquals(null, (Object)e.getAttributeValue(NAME1));
        Assert.assertEquals((long)0L, (long)e.getAttributeIndex(NAME1));
        Assert.assertEquals((long)-1L, (long)e.getAttributeIndex(NAME2));
        Assert.assertFalse((boolean)e.hasAttribute(NAME2));
        Assert.assertEquals((long)1L, (long)e.getAttributes().size());
        Assert.assertEquals((Object)Boolean.TRUE, (Object)e.getAttributeAsOptionalBoolean(NAME1, Boolean.TRUE));
        Assert.assertEquals((Object)new Long(0L), (Object)e.getAttributeAsOptionalLong(NAME1, Long.valueOf(0L)));
        Assert.assertEquals((Object)new Integer(0), (Object)e.getAttributeAsOptionalInt(NAME1, Integer.valueOf(0)));
        Assert.assertEquals((Object)new Short(0), (Object)e.getAttributeAsOptionalShort(NAME1, Short.valueOf((short)0)));
        Assert.assertEquals((Object)new Byte(0), (Object)e.getAttributeAsOptionalByte(NAME1, Byte.valueOf((byte)0)));
        Assert.assertEquals((Object)new Double(0.0), (Object)e.getAttributeAsOptionalDouble(NAME1, Double.valueOf(0.0)));
        Assert.assertEquals((Object)new Float(0.0f), (Object)e.getAttributeAsOptionalFloat(NAME1, Float.valueOf(0.0f)));
        Assert.assertEquals((Object)FailureReaction.DEFAULT, (Object)e.getAttributeAsOptionalEnum(NAME1, FailureReaction.class, (Enum)FailureReaction.DEFAULT));
    }

    @Test
    public void testChildren() {
        Element e = new Element(NAME);
        Assert.assertEquals(null, (Object)e.getDocument());
        Assert.assertEquals((Object)e, (Object)e.getRootElement());
        Assert.assertEquals((Object)e, (Object)e.getRootChild());
        Element c0 = e.addElement(NAME1);
        Element c1 = e.addElement(NAME1);
        Text c2 = e.addText("Hello");
        Comment c3 = e.addComment("Hello");
        Assert.assertEquals((Object)c0, (Object)e.getChildAt(0));
        Assert.assertEquals((Object)c1, (Object)e.getChildAt(1));
        Assert.assertEquals((Object)c0, (Object)e.getElementNamed(NAME1));
        Assert.assertEquals(null, (Object)c2.getDocument());
        Assert.assertEquals((Object)e, (Object)c3.getRootElement());
        Assert.assertEquals((Object)e, (Object)c3.getRootChild());
        Assert.assertEquals((Object)e, (Object)c2.getParent());
        Assert.assertEquals((Object)e, (Object)c2.getParent(Element.class));
        Assert.assertEquals((long)4L, (long)e.getChildrenCount());
        Assert.assertEquals((long)4L, (long)e.getChildrenCount(Node.class));
        Assert.assertEquals((long)2L, (long)e.getChildrenCount(Element.class));
        Assert.assertEquals((long)1L, (long)e.getChildrenCount(Comment.class));
        Assert.assertEquals((long)1L, (long)e.getChildrenCount(Text.class));
        Assert.assertEquals((long)2L, (long)e.getChildrenCount(Parent.class));
        Assert.assertEquals((long)4L, (long)e.getChildrenCount(Child.class));
        Assert.assertEquals((long)2L, (long)e.getChildrenCount(Leaf.class));
    }

    @Test
    public void testGetText() {
        Element e = new Element(NAME);
        Assert.assertEquals(null, (Object)e.getText());
        e.addComment("Hello");
        Assert.assertEquals(null, (Object)e.getText());
        e.removeChildAt(0);
        Assert.assertEquals(null, (Object)e.getText());
        e.addComment("Comment");
        e.addText("Hello");
        Assert.assertEquals((Object)"Hello", (Object)e.getText());
        e.addText("World");
        Assert.assertEquals((Object)"HelloWorld", (Object)e.getText());
        e.addElement("Child");
        Assert.assertEquals(null, (Object)e.getText());
        e.removeChildren();
        e.addText("Hello", false);
        e.addComment("Comment");
        e.addText("World", false);
        Assert.assertEquals((Object)"HelloWorld", (Object)e.getText());
        e.removeChildren();
        e.addText("true");
        Assert.assertEquals((Object)true, (Object)e.getTextAsBoolean(false));
        Assert.assertEquals((Object)true, (Object)e.getTextAsOptionalBoolean(null));
        e.removeChildren();
        e.addText("10");
        Assert.assertEquals((long)10L, (long)e.getTextAsLong(0L));
        Assert.assertEquals((Object)new Long(10L), (Object)e.getTextAsOptionalLong(null));
        Assert.assertEquals((long)10L, (long)e.getTextAsInt(0));
        Assert.assertEquals((Object)new Integer(10), (Object)e.getTextAsOptionalInt(null));
        Assert.assertEquals((long)10L, (long)e.getTextAsShort((short)0));
        Assert.assertEquals((Object)new Short(10), (Object)e.getTextAsOptionalShort(null));
        Assert.assertEquals((long)10L, (long)e.getTextAsByte((byte)0));
        Assert.assertEquals((Object)new Byte(10), (Object)e.getTextAsOptionalByte(null));
    }

    @Test
    public void testRemoveChildren() {
        Element root = new Element(NAME);
        root.addElement(NAME1);
        root.addElement(NAME2);
        root.addElement(NAME1);
        root.removeElementsNamed(NAME1);
        Assert.assertEquals((long)1L, (long)root.getChildrenCount(Element.class));
        Assert.assertEquals((long)0L, (long)root.getChildrenCount(Element.class, Element.named((String)NAME1)));
    }
}

