/*
 * Decompiled with CFR 0.152.
 */
package cdc.test.util.data;

import cdc.util.data.Child;
import cdc.util.data.Comment;
import cdc.util.data.Element;
import cdc.util.data.Node;
import cdc.util.data.Text;
import cdc.util.data.xml.XmlDataWriter;
import cdc.util.function.Iterables;
import cdc.util.lang.ComparatorsUtil;
import cdc.util.xml.XmlWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Comparator;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.io.IoBuilder;
import org.junit.Assert;
import org.junit.Test;

public class ParentTest {
    private static final Logger LOGGER = LogManager.getLogger(ParentTest.class);
    private static final PrintStream OUT = IoBuilder.forLogger((Logger)LOGGER).setLevel(Level.INFO).buildPrintStream();
    private static final String NAME = "name";
    private static final String NAME1 = "name1";
    private static final String NAME2 = "name2";
    private static final String VALUE = "value";

    private static void print(Node node) {
        try {
            OUT.println("=====================");
            XmlDataWriter.print((Node)node, (boolean)false, (PrintStream)OUT, (String)"  ", (boolean)false, (XmlWriter.Feature[])new XmlWriter.Feature[]{XmlWriter.Feature.APPEND_FINAL_EOL});
            OUT.println();
        }
        catch (IOException e) {
            LOGGER.catching((Throwable)e);
        }
    }

    @Test
    public void testGetChildren() {
        Element root = new Element(NAME);
        Assert.assertEquals(null, (Object)root.getLastChild());
        Element child1 = root.addElement(NAME1);
        Element child2 = root.addElement(NAME2);
        Element child3 = root.addElement(NAME1);
        child3.addAttribute(NAME, VALUE);
        Comment child4 = root.addComment("Hello");
        Assert.assertEquals((long)4L, (long)root.getChildrenCount());
        Assert.assertTrue((boolean)root.hasChildren(Element.class));
        Assert.assertTrue((boolean)root.hasChildren(Comment.class));
        Assert.assertFalse((boolean)root.hasChildren(Text.class));
        Assert.assertEquals((Object)child4, (Object)root.getLastChild());
        Assert.assertEquals((Object)child1, (Object)root.getChild(Element.class));
        Assert.assertEquals((Object)child1, (Object)root.getElementNamed(NAME1));
        Assert.assertEquals((long)3L, (long)root.getChildrenCount(Element.class));
        Assert.assertEquals((long)2L, (long)root.getChildrenCount(Element.class, Element.named((String)NAME1)));
        Assert.assertEquals((Object)child2, (Object)root.getChild(Element.class, Element.named((String)NAME2)));
        Assert.assertEquals((Object)child2, (Object)root.getChildAt(Element.class, Element.named((String)NAME2), 0));
        Assert.assertEquals(null, (Object)root.getChildAt(Element.class, Element.named((String)NAME2), 1));
        Assert.assertEquals((Object)child3, (Object)root.getChildAt(2));
        Assert.assertEquals((Object)child3, (Object)root.getChildAt(Element.class, 2));
        Assert.assertEquals((Object)child4, (Object)root.getChildAt(Comment.class, 0));
        Assert.assertEquals((long)3L, (long)Iterables.size((Iterable)root.getElements()));
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)root.getComments()));
        Assert.assertEquals((long)0L, (long)Iterables.size((Iterable)root.getTexts()));
        Assert.assertEquals((Object)child3, (Object)root.getElementNamedWithAttribute(NAME1, NAME, VALUE));
    }

    @Test
    public void testRemoveChildren() {
        Element root = new Element(NAME);
        Element child = root.addElement(NAME);
        root.removeChildren();
        Assert.assertEquals((long)0L, (long)root.getChildrenCount());
        Assert.assertFalse((boolean)root.removeChild((Child)child));
        root.addElement(NAME);
        root.addComment("Hello");
        root.addElement(NAME);
        root.addText("World");
        root.addElement(NAME);
        root.removeComments();
        Assert.assertEquals((long)4L, (long)root.getChildrenCount());
        root.removeTexts();
        Assert.assertEquals((long)3L, (long)root.getChildrenCount());
        root.addElement(NAME1);
        root.removeElementsNamed(NAME);
        Assert.assertEquals((long)1L, (long)root.getChildrenCount());
    }

    @Test
    public void testMerge() {
        Element root = new Element(NAME);
        root.addElement(NAME);
        root.addComment("Hello");
        Assert.assertEquals((long)1L, (long)root.getChildrenCount(Comment.class));
        root.addComment("World");
        Assert.assertEquals((long)1L, (long)root.getChildrenCount(Comment.class));
        root.addComment("Foo", false);
        Assert.assertEquals((long)2L, (long)root.getChildrenCount(Comment.class));
        root.mergeComments();
        Assert.assertEquals((long)1L, (long)root.getChildrenCount(Comment.class));
        root.removeChildren();
        root.addElement(NAME);
        root.addComment("Hello", false);
        root.addElement(NAME);
        root.addComment("Hello", false);
        root.addComment("Hello", false);
        root.addText("Hello", false);
        root.addComment("Hello", false);
        root.addComment("Hello", false);
        root.addText("Hello", false);
        root.addText("Hello", false);
        Assert.assertEquals((long)5L, (long)root.getChildrenCount(Comment.class));
        Assert.assertEquals((long)3L, (long)root.getChildrenCount(Text.class));
        root.mergeComments();
        Assert.assertEquals((long)3L, (long)root.getChildrenCount(Comment.class));
        Assert.assertEquals((long)3L, (long)root.getChildrenCount(Text.class));
        root.mergeTexts();
        Assert.assertEquals((long)3L, (long)root.getChildrenCount(Comment.class));
        Assert.assertEquals((long)2L, (long)root.getChildrenCount(Text.class));
        root.removeChildren();
        root.addComment("hello", false);
        root.addComment("hello", false);
        root.addText("Hello", false);
        root.addText("Hello", false);
        root.addComment("hello", false);
        root.addComment("hello", false);
        root.addText("Hello", false);
        root.addText("Hello", false);
        Element child = root.addElement("child");
        child.addComment("hello", false);
        child.addComment("hello", false);
        child.addText("Hello", false);
        child.addText("Hello", false);
        child.addComment("hello", false);
        child.addComment("hello", false);
        child.addText("Hello", false);
        child.addText("Hello", false);
        root.addComment("hello", false);
        root.addComment("hello", false);
        root.addText("Hello", false);
        root.addText("Hello", false);
        root.addComment("hello", false);
        root.addComment("hello", false);
        root.addText("Hello", false);
        root.addText("Hello", false);
        root.mergeComments(true);
        root.mergeTexts(true);
        Assert.assertEquals((long)4L, (long)root.getChildrenCount(Comment.class));
        Assert.assertEquals((long)2L, (long)child.getChildrenCount(Comment.class));
        Assert.assertEquals((long)4L, (long)root.getChildrenCount(Text.class));
        Assert.assertEquals((long)2L, (long)child.getChildrenCount(Text.class));
    }

    @Test
    public void testChangeTexts() {
        Element root = new Element(NAME);
        root.addText("hello", false);
        root.addText("HELLO", false);
        root.changeTexts(String::toUpperCase);
        Assert.assertEquals((long)2L, (long)root.getChildrenCount());
        Assert.assertEquals((Object)"HELLO", (Object)((Text)root.getChildAt(Text.class, 0)).getContent());
        Assert.assertEquals((Object)"HELLO", (Object)((Text)root.getChildAt(Text.class, 1)).getContent());
        root.removeChildren();
        Element child1 = root.addElement(NAME1);
        Element child2 = root.addElement(NAME2);
        Element child3 = root.addElement(NAME1);
        child1.addText("hello");
        child2.addText("hello");
        child3.addText("hel");
        child3.addText("lo", false);
        Assert.assertEquals((long)2L, (long)child3.getChildrenCount());
        root.changeTexts(String::toUpperCase);
        Assert.assertEquals((long)2L, (long)child3.getChildrenCount());
        root.changeNamedTexts(NAME1, String::toUpperCase);
        Assert.assertEquals((long)1L, (long)child3.getChildrenCount());
        Assert.assertEquals((Object)"HELLO", (Object)child1.getText());
        Assert.assertEquals((Object)"HELLO", (Object)child3.getText());
    }

    @Test
    public void testChangeComments() {
        Element root = new Element(NAME);
        root.addComment("hello", false);
        root.addComment("HELLO", false);
        root.changeComments(String::toUpperCase);
        Assert.assertEquals((long)2L, (long)root.getChildrenCount());
        Assert.assertEquals((Object)"HELLO", (Object)((Comment)root.getChildAt(Comment.class, 0)).getContent());
        Assert.assertEquals((Object)"HELLO", (Object)((Comment)root.getChildAt(Comment.class, 1)).getContent());
        root.removeChildren();
        Element child1 = root.addElement(NAME1);
        Element child2 = root.addElement(NAME2);
        Element child3 = root.addElement(NAME1);
        child1.addComment("hello");
        child2.addComment("hello");
        child3.addComment("hel");
        child3.addComment("lo", false);
        Assert.assertEquals((long)2L, (long)child3.getChildrenCount());
        root.changeComments(String::toUpperCase, true);
        Assert.assertEquals((long)2L, (long)child3.getChildrenCount());
        Assert.assertEquals((Object)"HELLO", (Object)((Comment)child1.getChild(Comment.class)).getContent());
        Assert.assertEquals((Object)"HEL", (Object)((Comment)child3.getChildAt(Comment.class, 0)).getContent());
    }

    @Test
    public void testSortNoChildren() {
        Element root = new Element("root");
        root.sortChildren(ComparatorsUtil.adapt(Element.class, (Comparator)Element.NAME_COMPARATOR));
    }

    @Test
    public void testSortName() {
        Element root = new Element("root");
        int i = 9;
        while (i >= 0) {
            root.addElement("child-" + i);
            --i;
        }
        Assert.assertEquals((Object)root.getElementNamed("child-0"), (Object)root.getChildAt(9));
        root.sortChildren(ComparatorsUtil.adapt(Element.class, (Comparator)Element.NAME_COMPARATOR));
        Assert.assertEquals((Object)root.getElementNamed("child-0"), (Object)root.getChildAt(0));
    }

    @Test
    public void testSortAttribute() {
        Element root = new Element("root");
        int i = 9;
        while (i >= 0) {
            Element child = root.addElement("child");
            child.addAttribute("id", i);
            --i;
        }
        Assert.assertEquals((Object)root.getElementNamedWithAttribute("child", "id", "0"), (Object)root.getChildAt(9));
        root.sortChildren(ComparatorsUtil.adapt(Element.class, (Comparator)Element.compareAttribute((String)"id")));
        Assert.assertEquals((Object)root.getElementNamedWithAttribute("child", "id", "0"), (Object)root.getChildAt(0));
    }
}

