/*
 * Decompiled with CFR 0.152.
 */
package cdc.test.util.data;

import cdc.util.data.Child;
import cdc.util.data.Document;
import cdc.util.data.Element;
import cdc.util.data.Node;
import cdc.util.data.NodeType;
import cdc.util.data.Parent;
import cdc.util.data.Text;
import org.junit.Assert;
import org.junit.Test;

public class TextTest {
    private static final String HELLO = "Hello";
    private static final String NAME = "name";

    @Test
    public void testConstructors1() {
        Text x = new Text();
        Assert.assertEquals((Object)NodeType.TEXT, (Object)x.getType());
        Assert.assertEquals(null, (Object)x.getParent());
        Assert.assertEquals((Object)"", (Object)x.getContent());
        Assert.assertEquals((long)"".hashCode(), (long)x.hashCode());
        x.setContent(HELLO);
        Assert.assertEquals((Object)HELLO, (Object)x.getContent());
        x.clearContent();
        Assert.assertEquals((Object)"", (Object)x.getContent());
        x.appendContent(HELLO);
        Assert.assertEquals((Object)HELLO, (Object)x.getContent());
        x.appendContent(null);
        Assert.assertEquals((Object)HELLO, (Object)x.getContent());
        Assert.assertEquals(null, (Object)x.getRootElement());
        Assert.assertEquals(null, (Object)x.getDocument());
        Assert.assertEquals((Object)x, (Object)x.getRootChild());
        Assert.assertTrue((boolean)x.deepEquals((Node)x));
        Assert.assertFalse((boolean)x.deepEquals(null));
    }

    @Test
    public void testConstructors2() {
        Document doc = new Document();
        Text x = new Text((Parent)doc);
        Assert.assertEquals((Object)NodeType.TEXT, (Object)x.getType());
        Assert.assertEquals((Object)doc, (Object)x.getParent());
        Assert.assertEquals((Object)"", (Object)x.getContent());
        x.setContent(HELLO);
        Assert.assertEquals((Object)HELLO, (Object)x.getContent());
        x.clearContent();
        Assert.assertEquals((Object)"", (Object)x.getContent());
        x.appendContent(HELLO);
        Assert.assertEquals((Object)HELLO, (Object)x.getContent());
        x.appendContent(null);
        Assert.assertEquals((Object)HELLO, (Object)x.getContent());
        Assert.assertEquals(null, (Object)x.getRootElement());
        Assert.assertEquals((Object)doc, (Object)x.getDocument());
        Assert.assertEquals((Object)x, (Object)x.getRootChild());
    }

    @Test
    public void testClone() {
        Text x1 = new Text(null, HELLO);
        Text x2 = x1.clone(false);
        Text x3 = x1.clone(true);
        Assert.assertEquals((Object)x1, (Object)x2);
        Assert.assertEquals((Object)x1, (Object)x3);
    }

    @Test
    public void testIsIgnorableWhiteSpace() {
        Text x = new Text();
        Assert.assertTrue((boolean)x.isIgnorable());
        x.setContent(" ");
        Assert.assertTrue((boolean)x.isIgnorable());
        x.setContent("\t");
        Assert.assertTrue((boolean)x.isIgnorable());
        x.setContent("\n");
        Assert.assertTrue((boolean)x.isIgnorable());
        x.setContent("\r");
        Assert.assertTrue((boolean)x.isIgnorable());
        x.setContent("\f");
        Assert.assertTrue((boolean)x.isIgnorable());
        x.setContent("a");
        Assert.assertFalse((boolean)x.isIgnorable());
    }

    @Test
    public void testGetRootElement() {
        Text x = new Text(HELLO);
        Assert.assertEquals(null, (Object)x.getRootElement());
        Element root = new Element(NAME);
        root.addChild((Child)x);
        Assert.assertEquals((Object)root, (Object)x.getRootElement());
    }
}

