/*
 * Decompiled with CFR 0.152.
 */
package cdc.test.util.data;

import cdc.util.data.Attribute;
import cdc.util.data.Comment;
import cdc.util.data.Document;
import cdc.util.data.Element;
import cdc.util.data.Node;
import cdc.util.data.Text;
import cdc.util.data.util.DataStats;
import cdc.util.data.util.DataUtil;
import cdc.util.data.xml.XmlDataReader;
import cdc.util.data.xml.XmlDataWriter;
import cdc.util.debug.Memory;
import cdc.util.files.Files;
import cdc.util.time.Chronometer;
import cdc.util.xml.XmlWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.function.Predicate;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.io.IoBuilder;
import org.junit.Assert;
import org.junit.Test;

public class XmlDataReaderTest {
    private static final Logger LOGGER = LogManager.getLogger(XmlDataReaderTest.class);
    private static final PrintStream OUT = IoBuilder.forLogger((Logger)LOGGER).setLevel(Level.DEBUG).buildPrintStream();

    private static void generateTestData(String filename) {
        try {
            int folders = 20;
            int objects = 500;
            int attributes = 100;
            XmlWriter writer = new XmlWriter(filename, "UTF-8");
            writer.setEnabled(XmlWriter.Feature.PRETTY_PRINT, true);
            writer.beginDocument();
            writer.beginElement("root");
            int findex = 0;
            while (findex < 20) {
                writer.beginElement("folder");
                writer.addAttribute("type", "type" + findex);
                int oindex = 0;
                while (oindex < 500) {
                    writer.beginElement("object");
                    writer.addAttribute("id", String.valueOf(findex) + "." + oindex);
                    writer.addAttribute("type", "type" + findex);
                    int aindex = 0;
                    while (aindex < 100) {
                        writer.beginElement("attribute");
                        writer.addAttribute("name", "att" + aindex);
                        writer.addAttribute("value", "value" + aindex);
                        writer.endElement();
                        ++aindex;
                    }
                    writer.endElement();
                    ++oindex;
                }
                writer.endElement();
                ++findex;
            }
            writer.endElement();
            writer.endDocument();
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testAttributeNameConversion() throws IOException {
        XmlDataReader reader = new XmlDataReader();
        reader.setEnabled(XmlDataReader.Feature.LOAD_SPACES, false);
        reader.setAttributeNameConverter((element, name) -> name.toUpperCase());
        URL url = this.getClass().getClassLoader().getResource("test-reader.xml");
        Document doc = reader.read(Files.toFile((URL)url).getPath());
        Assert.assertTrue((boolean)DataUtil.hasAllDescendantsMatching((Node)doc, node -> {
            if (node instanceof Element) {
                Element e = (Element)node;
                for (Attribute a : e.getAttributes()) {
                    if (a.getName().toUpperCase().equals(a.getName())) continue;
                    return false;
                }
                return true;
            }
            return true;
        }, (boolean)true));
        LOGGER.debug("Upper case attribute names");
        XmlDataWriter.print((Document)doc, (PrintStream)OUT, (String)"  ", (boolean)false, (XmlWriter.Feature[])new XmlWriter.Feature[0]);
    }

    @Test
    public void testAttributeValueConversion() throws IOException {
        XmlDataReader reader = new XmlDataReader();
        reader.setEnabled(XmlDataReader.Feature.LOAD_SPACES, false);
        reader.setAttributeValueConverter((element, name, value) -> value.toUpperCase());
        URL url = this.getClass().getClassLoader().getResource("test-reader.xml");
        Document doc = reader.read(Files.toFile((URL)url).getPath());
        LOGGER.debug("Upper case attribute values");
        XmlDataWriter.print((Document)doc, (PrintStream)OUT, (String)"  ", (boolean)false, (XmlWriter.Feature[])new XmlWriter.Feature[0]);
    }

    @Test
    public void testAttributeFiltering() throws IOException {
        XmlDataReader reader = new XmlDataReader();
        reader.setEnabled(XmlDataReader.Feature.LOAD_SPACES, false);
        reader.setAttributeFilter((element, name, value) -> "id".equals(name));
        URL url = this.getClass().getClassLoader().getResource("test-reader.xml");
        Document doc = reader.read(Files.toFile((URL)url).getPath());
        LOGGER.debug("Only id attributes");
        XmlDataWriter.print((Document)doc, (PrintStream)OUT, (String)"  ", (boolean)false, (XmlWriter.Feature[])new XmlWriter.Feature[0]);
    }

    @Test
    public void testElementNameConversion() throws IOException {
        XmlDataReader reader = new XmlDataReader();
        reader.setEnabled(XmlDataReader.Feature.LOAD_SPACES, false);
        reader.setElementNameConverter((parent, name) -> name.toUpperCase());
        URL url = this.getClass().getClassLoader().getResource("test-reader.xml");
        Document doc = reader.read(Files.toFile((URL)url).getPath());
        LOGGER.debug("Upper case element names");
        XmlDataWriter.print((Document)doc, (PrintStream)OUT, (String)"  ", (boolean)false, (XmlWriter.Feature[])new XmlWriter.Feature[0]);
    }

    @Test
    public void testElementFiltering() throws IOException {
        XmlDataReader reader = new XmlDataReader();
        reader.setEnabled(XmlDataReader.Feature.LOAD_SPACES, false);
        reader.setElementFilter((parent, element) -> "root".equals(element.getName()) || "E1".equals(element.getAttributeValue("id", "")) || "E1.1".equals(element.getAttributeValue("id", "")) || "E2".equals(element.getAttributeValue("id", "")));
        URL url = this.getClass().getClassLoader().getResource("test-reader.xml");
        Document doc = reader.read(Files.toFile((URL)url).getPath());
        LOGGER.debug("Only E1, E1.1 and E2");
        XmlDataWriter.print((Document)doc, (PrintStream)OUT, (String)"  ", (boolean)false, (XmlWriter.Feature[])new XmlWriter.Feature[0]);
    }

    @Test
    public void testLargeElementFiltering() throws IOException {
        File file = File.createTempFile("cdc-test", "xml");
        Chronometer chrono = new Chronometer();
        chrono.start();
        XmlDataReaderTest.generateTestData(file.getPath());
        chrono.suspend();
        LOGGER.debug("Generation time: " + chrono);
        Memory.warmUp();
        Memory.runGC();
        long init = Memory.usedMemory();
        XmlDataReader reader = new XmlDataReader();
        reader.setEnabled(XmlDataReader.Feature.LOAD_SPACES, false);
        reader.setEnabled(XmlDataReader.Feature.SHARE_ATTRIBUTE_NAMES, true);
        reader.setEnabled(XmlDataReader.Feature.SHARE_ELEMENT_NAMES, true);
        Predicate<Node> p = node -> {
            if (node instanceof Element) {
                Element e = (Element)node;
                return "folder".equals(e.getName()) && "type0".equals(e.getAttributeValue("type", ""));
            }
            return false;
        };
        reader.setElementFilter((parent, element) -> {
            boolean ok = "root".equals(element.getName()) || p.test((Node)element) || DataUtil.hasAncestorMatching((Node)parent, (Predicate)p);
            return ok;
        });
        XmlDataReader.CACHE.clear();
        chrono.start();
        Document doc = reader.read(file);
        Memory.runGC();
        long end = Memory.usedMemory();
        chrono.suspend();
        LOGGER.debug("Reading time: " + chrono + " " + (end - init));
        DataStats.print((Node)doc, (PrintStream)OUT);
        XmlDataReader.CACHE.print(OUT);
    }

    private static InputStream createInputStream(String s) {
        return new ByteArrayInputStream(s.getBytes());
    }

    @Test
    public void testFeaturesDefault0() {
        InputStream is = XmlDataReaderTest.createInputStream("<?xml version=\"1.0\" encoding=\"UTF-8\"?><!-- comment --><root/><!-- comment -->");
        try {
            Document doc = XmlDataReader.load((InputStream)is, (XmlDataReader.Feature[])new XmlDataReader.Feature[0]);
            Assert.assertEquals((long)1L, (long)doc.getChildrenCount());
            Assert.assertEquals((Object)"root", (Object)doc.getRootElement().getName());
            Assert.assertEquals((long)0L, (long)doc.getRootElement().getChildrenCount());
        }
        catch (IOException e) {
            LOGGER.catching((Throwable)e);
            Assert.assertFalse((boolean)true);
        }
    }

    @Test
    public void testFeaturesDefault1() {
        InputStream is = XmlDataReaderTest.createInputStream("<?xml version=\"1.0\" encoding=\"UTF-8\"?><!-- comment --><root></root><!-- comment -->");
        try {
            Document doc = XmlDataReader.load((InputStream)is, (XmlDataReader.Feature[])new XmlDataReader.Feature[0]);
            Assert.assertEquals((long)1L, (long)doc.getChildrenCount());
            Assert.assertEquals((Object)"root", (Object)doc.getRootElement().getName());
            Assert.assertEquals((long)0L, (long)doc.getRootElement().getChildrenCount());
        }
        catch (IOException e) {
            LOGGER.catching((Throwable)e);
            Assert.assertFalse((boolean)true);
        }
    }

    @Test
    public void testFeaturesDefault2() {
        InputStream is = XmlDataReaderTest.createInputStream("<?xml version=\"1.0\" encoding=\"UTF-8\"?><!-- comment --><root> <!-- comment -->  </root><!-- comment -->");
        try {
            Document doc = XmlDataReader.load((InputStream)is, (XmlDataReader.Feature[])new XmlDataReader.Feature[0]);
            Assert.assertEquals((long)1L, (long)doc.getChildrenCount());
            Assert.assertEquals((Object)"root", (Object)doc.getRootElement().getName());
            Assert.assertEquals((long)0L, (long)doc.getRootElement().getChildrenCount());
        }
        catch (IOException e) {
            LOGGER.catching((Throwable)e);
            Assert.assertFalse((boolean)true);
        }
    }

    @Test
    public void testFeaturesDefault3() {
        InputStream is = XmlDataReaderTest.createInputStream("<?xml version=\"1.0\" encoding=\"UTF-8\"?><!-- comment --><root><!-- comment -->aaa</root><!-- comment -->");
        try {
            Document doc = XmlDataReader.load((InputStream)is, (XmlDataReader.Feature[])new XmlDataReader.Feature[0]);
            Assert.assertEquals((long)1L, (long)doc.getChildrenCount());
            Assert.assertEquals((Object)"root", (Object)doc.getRootElement().getName());
            Assert.assertEquals((long)1L, (long)doc.getRootElement().getChildrenCount());
        }
        catch (IOException e) {
            LOGGER.catching((Throwable)e);
            Assert.assertFalse((boolean)true);
        }
    }

    @Test(expected=IOException.class)
    public void testFeaturesDefault4() throws IOException {
        InputStream is = XmlDataReaderTest.createInputStream("<?xml version=\"1.0\" encoding=\"UTF-8\"?><root>text<child/></root>");
        XmlDataReader.load((InputStream)is, (XmlDataReader.Feature[])new XmlDataReader.Feature[0]);
    }

    @Test(expected=IOException.class)
    public void testFeaturesDefault5() throws IOException {
        InputStream is = XmlDataReaderTest.createInputStream("<?xml version=\"1.0\" encoding=\"UTF-8\"?><root><child/>text</root>");
        XmlDataReader.load((InputStream)is, (XmlDataReader.Feature[])new XmlDataReader.Feature[0]);
    }

    @Test
    public void testFeaturesDefault6() {
        InputStream is = XmlDataReaderTest.createInputStream("<?xml version=\"1.0\" encoding=\"UTF-8\"?><root><child/></root>");
        try {
            XmlDataReader.load((InputStream)is, (XmlDataReader.Feature[])new XmlDataReader.Feature[0]);
        }
        catch (IOException e) {
            LOGGER.catching((Throwable)e);
            Assert.assertFalse((boolean)true);
        }
    }

    @Test
    public void testFeaturesDefault7() {
        InputStream is = XmlDataReaderTest.createInputStream("<?xml version=\"1.0\" encoding=\"UTF-8\"?> \n  <root> \n <child/> \n </root>");
        try {
            XmlDataReader.load((InputStream)is, (XmlDataReader.Feature[])new XmlDataReader.Feature[0]);
        }
        catch (IOException e) {
            LOGGER.catching((Throwable)e);
            Assert.assertFalse((boolean)true);
        }
    }

    @Test
    public void testFeaturesComments() {
        InputStream is = XmlDataReaderTest.createInputStream("<?xml version=\"1.0\" encoding=\"UTF-8\"?> \n <!--comment--> <root> \n <child/> \n </root>");
        try {
            Document doc = XmlDataReader.load((InputStream)is, (XmlDataReader.Feature[])new XmlDataReader.Feature[]{XmlDataReader.Feature.LOAD_COMMENTS});
            Assert.assertEquals((long)2L, (long)doc.getChildrenCount());
            Assert.assertEquals((long)1L, (long)doc.getChildrenCount(Comment.class));
        }
        catch (IOException e) {
            LOGGER.catching((Throwable)e);
            Assert.assertFalse((boolean)true);
        }
    }

    @Test
    public void testFeaturesMixed() {
        InputStream is = XmlDataReaderTest.createInputStream("<?xml version=\"1.0\" encoding=\"UTF-8\"?> \n <!--comment--> <root>aaa\naaa<child/>aaa\naaa</root>");
        try {
            Document doc = XmlDataReader.load((InputStream)is, (XmlDataReader.Feature[])new XmlDataReader.Feature[]{XmlDataReader.Feature.LOAD_COMMENTS, XmlDataReader.Feature.ALLOW_MIXED_CONTENT});
            Assert.assertEquals((long)2L, (long)doc.getChildrenCount());
            Assert.assertEquals((long)1L, (long)doc.getChildrenCount(Comment.class));
            Assert.assertEquals((long)3L, (long)doc.getRootElement().getChildrenCount());
            Assert.assertEquals((long)2L, (long)doc.getRootElement().getChildrenCount(Text.class));
        }
        catch (IOException e) {
            LOGGER.catching((Throwable)e);
            Assert.assertFalse((boolean)true);
        }
    }
}

