/*
 * Decompiled with CFR 0.152.
 */
package cdc.util.data;

import cdc.util.data.Child;
import cdc.util.data.Document;
import cdc.util.data.Element;
import cdc.util.data.NodeType;
import cdc.util.data.Parent;
import cdc.util.lang.CollectionsUtil;

public abstract class AbstractChild
implements Child {
    private Parent parent;

    protected AbstractChild() {
    }

    @Override
    public abstract AbstractChild clone(boolean var1);

    @Override
    public final Child getRootChild() {
        AbstractChild index = this;
        while (index.parent instanceof AbstractChild) {
            index = (AbstractChild)((Object)index.parent);
        }
        return index;
    }

    @Override
    public final Document getDocument() {
        Element root = this.getRootElement();
        if (root != null) {
            return (Document)root.getParent();
        }
        return (Document)this.getParent();
    }

    @Override
    public final Element getRootElement() {
        Child root = this.getRootChild();
        if (root.getType() == NodeType.DOCUMENT) {
            return ((Document)((Object)root)).getRootElement();
        }
        if (root.getType() == NodeType.ELEMENT) {
            return (Element)root;
        }
        return null;
    }

    @Override
    public final Parent getParent() {
        return this.parent;
    }

    protected void resetParent() {
        this.parent = null;
    }

    @Override
    public final void setParent(Parent parent) {
        if (parent != this.parent) {
            if (parent == null || parent.canAddChild(this)) {
                if (this.parent != null) {
                    this.parent.doRemoveChild(this);
                    this.parent = null;
                }
                if (parent != null) {
                    parent.doAddChild(this);
                    this.parent = parent;
                }
            } else {
                throw new IllegalStateException("Can not set parent. child: " + (Object)((Object)this.getType()) + " parent: " + (Object)((Object)parent.getType()));
            }
        }
    }

    @Override
    public int getIndex() {
        if (this.getParent() != null) {
            return this.getParent().getChildren().indexOf(this);
        }
        return -1;
    }

    @Override
    public void setIndex(int to) {
        CollectionsUtil.setIndex(this.getParent().getChildren(), (Object)this, (int)to);
    }

    @Override
    public final void remove() {
        this.setParent(null);
    }

    public String toString() {
        return this.getType().name();
    }
}

