/*
 * Decompiled with CFR 0.152.
 */
package cdc.util.data;

import cdc.util.data.Document;
import cdc.util.data.Element;
import cdc.util.data.NodeType;
import cdc.util.data.Text;
import java.util.function.Predicate;

public interface Node {
    public static final Predicate<Node> ANY_NODE = n -> true;
    public static final Predicate<Node> IS_COMMENT = node -> node.getType() == NodeType.COMMENT;
    public static final Predicate<Node> IS_ELEMENT = node -> node.getType() == NodeType.ELEMENT;
    public static final Predicate<Node> IS_TEXT = node -> node.getType() == NodeType.TEXT;
    public static final Predicate<Node> IS_EMPTY_ELEMENT = node -> {
        if (node.getType() == NodeType.ELEMENT) {
            Element element = (Element)node;
            return element.getAttributesCount() == 0 && element.getChildrenCount() == 0;
        }
        return false;
    };
    public static final Predicate<Node> IS_IGNORABLE_TEXT = node -> {
        if (node.getType() == NodeType.TEXT) {
            Text text = (Text)node;
            return text.isIgnorable();
        }
        return false;
    };

    public NodeType getType();

    public Node clone(boolean var1);

    public boolean deepEquals(Node var1);

    public Document getDocument();

    public Element getRootElement();
}

