/*
 * Decompiled with CFR 0.152.
 */
package cdc.util.data;

import cdc.util.data.AbstractChild;
import cdc.util.data.Child;
import cdc.util.data.Comment;
import cdc.util.data.Element;
import cdc.util.data.Node;
import cdc.util.data.NodeType;
import cdc.util.data.Text;
import cdc.util.function.Iterables;
import cdc.util.function.Predicates;
import cdc.util.lang.Checks;
import cdc.util.lang.Operators;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;

public interface Parent
extends Node {
    public static final /* synthetic */ boolean $assertionsDisabled;
    public static final /* synthetic */ int[] $SWITCH_TABLE$cdc$util$data$ElementContentType;

    @Override
    public Parent clone(boolean var1);

    public boolean canAddChild(Child var1);

    public void doAddChild(Child var1);

    public void doRemoveChild(Child var1);

    public List<AbstractChild> getChildren();

    default public <T extends Node> Iterable<T> getChildren(Class<T> childClass) {
        return Iterables.filterAndConvert(childClass, this.getChildren(), (Predicate)Predicates.isInstanceOf(childClass));
    }

    default public <T extends Node> Iterable<T> getChildren(Class<T> childClass, Predicate<? super T> predicate) {
        return Iterables.filterAndConvert(childClass, this.getChildren(), Predicates.isInstanceOf(childClass).and(predicate));
    }

    default public <T extends Node> T getChild(Class<T> childClass, Predicate<? super T> predicate) {
        return (T)((Node)Iterables.getFirstOrNull(this.getChildren(childClass, predicate)));
    }

    default public <T extends Node> T getChild(Class<T> childClass) {
        return this.getChild(childClass, Predicates.alwaysTrue());
    }

    default public <T extends Node> T getChildAt(Class<T> childClass, Predicate<? super T> predicate, int index) {
        return (T)((Node)Iterables.getAtOrNull(this.getChildren(childClass, predicate), (int)index));
    }

    default public <T extends Node> T getChildAt(Class<T> childClass, int index) {
        return (T)((Node)Iterables.getAtOrNull(this.getChildren(childClass), (int)index));
    }

    default public Iterable<Element> getElements() {
        return this.getChildren(Element.class);
    }

    default public boolean hasElements() {
        return !Iterables.isEmpty(this.getElements());
    }

    default public Iterable<Element> getElementsNamed(String name) {
        return this.getChildren(Element.class, Element.named(name));
    }

    default public Element getElementNamedAt(String name, int index) {
        return (Element)Iterables.getAtOrNull(this.getElementsNamed(name), (int)index);
    }

    default public Element getElementNamed(String name) {
        return this.getElementNamedAt(name, 0);
    }

    default public Iterable<Element> getElementsNamedIgnoreCase(String name) {
        return this.getChildren(Element.class, Element.namedIgnoreCase(name));
    }

    default public Element getElementNamedIgnoreCaseAt(String name, int index) {
        return (Element)Iterables.getAtOrNull(this.getElementsNamedIgnoreCase(name), (int)index);
    }

    default public Element getElementNamedIgnoreCase(String name) {
        return this.getElementNamedIgnoreCaseAt(name, 0);
    }

    default public Element getElementNamedWithAttribute(String name, String attributeName, String attributeValue) {
        return (Element)this.getChild(Element.class, Element.namedWithAttribute(name, attributeName, attributeValue));
    }

    default public Iterable<Text> getTexts() {
        return this.getChildren(Text.class);
    }

    default public boolean hasTexts() {
        return !Iterables.isEmpty(this.getTexts());
    }

    default public Iterable<Comment> getComments() {
        return this.getChildren(Comment.class);
    }

    default public boolean hasComments() {
        return !Iterables.isEmpty(this.getComments());
    }

    default public <T extends Node> int getChildrenCount(Class<T> childClass, Predicate<? super T> predicate) {
        return Iterables.size(this.getChildren(childClass, predicate));
    }

    default public int getChildrenCount(Class<? extends Node> childClass) {
        return Iterables.size(this.getChildren(childClass));
    }

    default public int getChildrenCount() {
        return this.getChildren().size();
    }

    default public <T extends Node> boolean hasChildren(Class<T> childClass, Predicate<? super T> predicate) {
        return !Iterables.isEmpty(this.getChildren(childClass, predicate));
    }

    default public boolean hasChildren(Class<? extends Node> childClass) {
        return !Iterables.isEmpty(this.getChildren(childClass));
    }

    default public boolean hasChildren() {
        return !Iterables.isEmpty(this.getChildren());
    }

    default public Child getChildAt(int index) {
        return this.getChildren().get(index);
    }

    default public Child getLastChild() {
        List<AbstractChild> children = this.getChildren();
        if (children.isEmpty()) {
            return null;
        }
        return children.get(children.size() - 1);
    }

    default public <C extends Child> C addChild(C child) {
        Checks.isNotNull(child, (String)"child");
        child.setParent(this);
        return child;
    }

    default public Element addElement(String name) {
        Element child = new Element(name);
        return this.addChild(child);
    }

    default public void addChildren(Iterable<? extends Child> children) {
        for (Child child : children) {
            this.addChild(child);
        }
    }

    default public void addChildren(Child ... children) {
        Child[] childArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Child child = childArray[n2];
            this.addChild(child);
            ++n2;
        }
    }

    default public boolean removeChild(Child child) {
        if (child != null && child.getParent() == this) {
            child.setParent(null);
            return true;
        }
        return false;
    }

    default public Child removeChildAt(int index) {
        AbstractChild removed = this.getChildren().remove(index);
        removed.resetParent();
        return removed;
    }

    default public void removeChildren() {
        while (this.hasChildren()) {
            this.removeChildAt(this.getChildrenCount() - 1);
        }
    }

    default public void removeChildren(Predicate<? super Child> predicate) {
        ArrayList<Integer> indices = null;
        int index = this.getChildrenCount() - 1;
        while (index >= 0) {
            Child child = this.getChildAt(index);
            if (predicate.test(child)) {
                if (indices == null) {
                    indices = new ArrayList<Integer>();
                }
                indices.add(index);
            }
            --index;
        }
        if (indices != null) {
            Iterator iterator = indices.iterator();
            while (iterator.hasNext()) {
                index = (Integer)iterator.next();
                Child removed = this.removeChildAt(index);
                assert (removed != null);
            }
        }
    }

    default public void removeChildren(Predicate<? super Child> predicate, boolean recurse) {
        this.removeChildren(predicate);
        if (recurse) {
            for (Element child : this.getElements()) {
                child.removeChildren(predicate, true);
            }
        }
    }

    default public void removeElementsNamed(String name) {
        this.removeChildren(Element.named(name));
    }

    default public void removeElementsNamed(String name, boolean recurse) {
        this.removeChildren(Element.named(name), recurse);
    }

    default public void removeComments() {
        this.removeChildren(IS_COMMENT);
    }

    default public void removeComments(boolean recurse) {
        this.removeChildren(IS_COMMENT, recurse);
    }

    default public void removeTexts() {
        this.removeChildren(IS_TEXT);
    }

    default public void removeTexts(boolean recurse) {
        this.removeChildren(IS_TEXT, recurse);
    }

    default public void removeIgnorableTexts() {
        this.removeChildren(IS_IGNORABLE_TEXT);
    }

    default public void removeIgnorableTexts(boolean recurse) {
        this.removeChildren(IS_IGNORABLE_TEXT, recurse);
    }

    default public void sortChildren(Comparator<? super Child> comparator) {
        if (this.hasChildren()) {
            Collections.sort(this.getChildren(), comparator);
        }
    }

    default public void sortChildren(Comparator<? super Child> comparator, boolean recurse) {
        this.sortChildren(comparator);
        if (recurse) {
            for (Element child : this.getElements()) {
                child.sortChildren(comparator, true);
            }
        }
    }

    default public void mergeTexts() {
        if (this.getChildrenCount() > 1) {
            Child ref = this.getChildAt(0);
            int index = 1;
            while (index < this.getChildrenCount()) {
                Child next = this.getChildAt(index);
                if (ref.getType() == NodeType.TEXT && next.getType() == NodeType.TEXT) {
                    ((Text)ref).appendContent(((Text)next).getContent());
                    next.remove();
                    continue;
                }
                ref = next;
                ++index;
            }
        }
    }

    default public void mergeTexts(boolean recurse) {
        this.mergeTexts();
        if (recurse) {
            for (Element child : this.getElements()) {
                child.mergeTexts(true);
            }
        }
    }

    default public void mergeComments() {
        if (this.getChildrenCount() > 1) {
            Child ref = this.getChildAt(0);
            int index = 1;
            while (index < this.getChildrenCount()) {
                Child next = this.getChildAt(index);
                if (ref.getType() == NodeType.COMMENT && next.getType() == NodeType.COMMENT) {
                    ((Comment)ref).appendContent(((Comment)next).getContent());
                    next.remove();
                    continue;
                }
                ref = next;
                ++index;
            }
        }
    }

    default public void mergeComments(boolean recurse) {
        this.mergeComments();
        if (recurse) {
            for (Element child : this.getElements()) {
                child.mergeComments(true);
            }
        }
    }

    default public void changeTexts(Function<String, String> modifier) {
        for (Text child : this.getTexts()) {
            String newContent;
            String content = child.getContent();
            if (!Operators.notEquals((Object)content, (Object)(newContent = modifier.apply(content)))) continue;
            child.setContent(newContent);
        }
    }

    default public void changeTexts(Function<String, String> modifier, boolean recurse) {
        this.changeTexts(modifier);
        if (recurse) {
            for (Element child : this.getElements()) {
                child.changeTexts(modifier, true);
            }
        }
    }

    default public void changeNamedTexts(String name, Function<String, String> modifier) {
        block3: for (Element child : this.getElementsNamed(name)) {
            switch (child.getContentType()) {
                case EMPTY: 
                case TEXT: {
                    String content = child.getText();
                    String newContent = modifier.apply(content);
                    if (!Operators.notEquals((Object)content, (Object)newContent)) break;
                    if (child.getChildrenCount(Text.class) == 1 && newContent != null && !newContent.isEmpty()) {
                        Text text = child.getChild(Text.class);
                        text.clearContent();
                        text.appendContent(newContent);
                        break;
                    }
                    child.removeChildren();
                    if (newContent == null || newContent.isEmpty()) continue block3;
                    child.addText(modifier.apply(content));
                    break;
                }
            }
        }
    }

    default public void changeNamedTexts(String name, Function<String, String> modifier, boolean recurse) {
        this.changeNamedTexts(name, modifier);
        if (recurse) {
            for (Element child : this.getElements()) {
                child.changeNamedTexts(name, modifier, true);
            }
        }
    }

    default public void changeComments(Function<String, String> modifier) {
        for (Comment child : this.getComments()) {
            String newContent;
            String content = child.getContent();
            if (!Operators.notEquals((Object)content, (Object)(newContent = modifier.apply(content)))) continue;
            child.setContent(newContent);
        }
    }

    default public void changeComments(Function<String, String> modifier, boolean recurse) {
        this.changeComments(modifier);
        if (recurse) {
            for (Element child : this.getElements()) {
                child.changeComments(modifier, true);
            }
        }
    }
}

