/*
 * Decompiled with CFR 0.152.
 */
package cdc.util.data.tools;

import cdc.util.cli.AbstractMainSupport;
import cdc.util.cli.EnumMask;
import cdc.util.cli.OptionEnum;
import cdc.util.data.Document;
import cdc.util.data.Element;
import cdc.util.data.Node;
import cdc.util.data.util.AttributePredicate;
import cdc.util.data.util.DataUtil;
import cdc.util.data.util.TextPredicate;
import cdc.util.data.xml.XmlDataReader;
import cdc.util.data.xml.XmlDataWriter;
import cdc.util.io.NonCloseableOutputStream;
import cdc.util.xml.XmlWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class XmlNormalizer {
    protected static final Logger LOGGER = LogManager.getLogger(XmlNormalizer.class);
    private final MainArgs margs;

    private XmlNormalizer(MainArgs margs) {
        this.margs = margs;
    }

    private void execute() throws IOException {
        XmlDataReader reader = new XmlDataReader();
        reader.setEnabled(XmlDataReader.Feature.LOAD_COMMENTS, !this.margs.isEnabled(MainArgs.Feature.REMOVE_COMMENTS));
        reader.setEnabled(XmlDataReader.Feature.LOAD_SPACES, !this.margs.isEnabled(MainArgs.Feature.PRETTY_PRINT));
        Document document = reader.read(this.margs.inputFile);
        if (!this.margs.removedElements.isEmpty()) {
            DataUtil.removeMatchingChildren(document, Element.named(this.margs.removedAttributes), DataUtil.RECURSE);
        }
        if (this.margs.isEnabled(MainArgs.Feature.REMOVE_EMPTY_ATTRIBUTES)) {
            DataUtil.removeEmptyAttributes(document, DataUtil.RECURSE);
        }
        if (!this.margs.removedAttributes.isEmpty()) {
            DataUtil.removeMatchingAttributes(document, AttributePredicate.fromNames(this.margs.removedAttributes), DataUtil.RECURSE);
        }
        if (this.margs.isEnabled(MainArgs.Feature.REMOVE_EMPTY_ELEMENTS)) {
            DataUtil.removeEmptyElements(document, DataUtil.RECURSE);
        }
        if (this.margs.isEnabled(MainArgs.Feature.SORT_ATTRIBUTES)) {
            DataUtil.sortAttributesByName(document, DataUtil.RECURSE);
        }
        if (this.margs.isEnabled(MainArgs.Feature.SORT_ELEMENTS)) {
            DataUtil.sortChildrenElementsByNameAndAttributes(document, Node.ANY_NODE, DataUtil.RECURSE);
        }
        if (this.margs.isEnabled(MainArgs.Feature.SCRAMBLE_ATTRIBUTES)) {
            DataUtil.scrambleValuesOfMatchingAttributes(document, AttributePredicate.ANY_ATTRIBUTE, DataUtil.RECURSE, true);
        }
        if (this.margs.isEnabled(MainArgs.Feature.SCRAMBLE_ELEMENTS)) {
            DataUtil.scrambleContentOfMatchingTexts(document, TextPredicate.ANY_TEXT, DataUtil.RECURSE, true);
        }
        for (String name : this.margs.firstAttributes) {
            DataUtil.moveAttributeFirst(document, Node.ANY_NODE, name, DataUtil.RECURSE);
        }
        if (!this.margs.scrambledAttributes.isEmpty()) {
            DataUtil.scrambleValuesOfMatchingAttributes(document, AttributePredicate.fromNames(this.margs.scrambledAttributes), DataUtil.RECURSE, true);
        }
        if (!this.margs.scrambledElements.isEmpty()) {
            DataUtil.scrambleContentOfMatchingTexts(document, TextPredicate.fromElementNames(this.margs.scrambledElements), DataUtil.RECURSE, true);
        }
        Throwable throwable = null;
        Iterator<String> iterator = null;
        try (XmlDataWriter writer = this.margs.outputFile == null ? new XmlDataWriter((OutputStream)NonCloseableOutputStream.NON_CLOSABLE_SYSTEM_OUT) : new XmlDataWriter(this.margs.outputFile);){
            writer.getXmlWriter().setEnabled(XmlWriter.Feature.PRETTY_PRINT, this.margs.isEnabled(MainArgs.Feature.PRETTY_PRINT));
            writer.getXmlWriter().setIndentString(this.margs.indentString);
            writer.write(document);
            writer.flush();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static void execute(MainArgs margs) throws IOException {
        XmlNormalizer instance = new XmlNormalizer(margs);
        instance.execute();
    }

    public static void main(String[] args) {
        MainSupport support = new MainSupport();
        support.main(args);
    }

    public static class MainArgs {
        public String indentString = "  ";
        public File inputFile;
        public File outputFile;
        public final List<String> firstAttributes = new ArrayList<String>();
        public final Set<String> scrambledAttributes = new HashSet<String>();
        public final Set<String> scrambledElements = new HashSet<String>();
        public final Set<String> removedAttributes = new HashSet<String>();
        public final Set<String> removedElements = new HashSet<String>();
        protected final EnumMask<Feature> features = new EnumMask();

        public void setEnabled(Feature feature, boolean enabled) {
            this.features.setEnabled((Enum)feature, enabled);
        }

        public boolean isEnabled(Feature feature) {
            return this.features.isEnabled((Enum)feature);
        }

        public static enum Feature implements OptionEnum
        {
            PRETTY_PRINT("pretty-print", "Pretty prints."),
            SORT_ATTRIBUTES("sort-attributes", "Sorts all attributes in alphabetical order."),
            SCRAMBLE_ATTRIBUTES("scramble-attributes", "Scramble values of all attributes. This can alter schema compliance."),
            SORT_ELEMENTS("sort-elements", "Sorts all children elements in alphabetical order. This can alter schema compliance."),
            SCRAMBLE_ELEMENTS("scramble-elements", "Scramble content of all (non-ignorable white space) elements. This can alter schema compliance."),
            REMOVE_EMPTY_ATTRIBUTES("remove-empty-attributes", "Removes all empty attributes. This can alter schema compliance."),
            REMOVE_EMPTY_ELEMENTS("remove-empty-elements", "Removes all empty elements. This can alter schema compliance."),
            REMOVE_COMMENTS("remove-comments", "Removes all comments.");

            private final String name;
            private final String description;

            private Feature(String name, String description) {
                this.name = name;
                this.description = description;
            }

            public final String getName() {
                return this.name;
            }

            public final String getDescription() {
                return this.description;
            }
        }
    }

    private static class MainSupport
    extends AbstractMainSupport<MainArgs, Void> {
        private static final String INDENT_STRING = "indent-string";
        private static final String FIRST_ATTRIBUTE = "first-attribute";
        private static final String SCRAMBLE_ATTRIBUTE = "scramble-attribute";
        private static final String SCRAMBLE_ELEMENT = "scramble-element";
        private static final String REMOVE_ATTRIBUTE = "remove-attribute";
        private static final String REMOVE_ELEMENT = "remove-element";

        public MainSupport() {
            super(XmlNormalizer.class, LOGGER);
        }

        protected String getVersion() {
            return "0.0.9";
        }

        protected void addSpecificOptions(Options options) {
            options.addOption(Option.builder().longOpt("input").desc("Xml input file.").hasArg().required().build());
            options.addOption(Option.builder().longOpt("output").desc("Optional Xml output file.").hasArg().build());
            options.addOption(Option.builder().longOpt(INDENT_STRING).desc("Optional indentation string. Used when " + MainArgs.Feature.PRETTY_PRINT.getName() + " is enabled").hasArg().build());
            options.addOption(Option.builder().longOpt(FIRST_ATTRIBUTE).desc("Optional name(s) of attributes to move to first position. Order of declarations matters. Executed after attributes sorting.").hasArgs().build());
            options.addOption(Option.builder().longOpt(SCRAMBLE_ATTRIBUTE).desc("Optional name(s) of attributes to scramble.").hasArgs().build());
            options.addOption(Option.builder().longOpt(SCRAMBLE_ELEMENT).desc("Optional name(s) of elements whoise content must be scrambled.").hasArgs().build());
            options.addOption(Option.builder().longOpt(REMOVE_ATTRIBUTE).desc("Optional name(s) of attributes to remove.").hasArgs().build());
            options.addOption(Option.builder().longOpt(REMOVE_ELEMENT).desc("Optional name(s) of elements to remove.").hasArgs().build());
            MainSupport.addNoArgOptions((Options)options, MainArgs.Feature.class);
        }

        protected MainArgs analyze(CommandLine cl) throws ParseException {
            MainArgs margs = new MainArgs();
            margs.inputFile = MainSupport.getValueAsNullOrExistingFile((CommandLine)cl, (String)"input", null);
            margs.outputFile = MainSupport.getValueAsFile((CommandLine)cl, (String)"output", null);
            margs.indentString = cl.getOptionValue(INDENT_STRING);
            this.fillValues(cl, FIRST_ATTRIBUTE, margs.firstAttributes);
            this.fillValues(cl, SCRAMBLE_ATTRIBUTE, margs.scrambledAttributes);
            this.fillValues(cl, SCRAMBLE_ELEMENT, margs.scrambledElements);
            this.fillValues(cl, REMOVE_ATTRIBUTE, margs.removedAttributes);
            this.fillValues(cl, REMOVE_ELEMENT, margs.removedElements);
            MainSupport.setMask((CommandLine)cl, MainArgs.Feature.class, (arg_0, arg_1) -> margs.features.setEnabled(arg_0, arg_1));
            return margs;
        }

        protected Void execute(MainArgs margs) throws Exception {
            XmlNormalizer.execute(margs);
            return null;
        }
    }
}

