/*
 * Decompiled with CFR 0.152.
 */
package cdc.util.data.util;

import cdc.util.data.Attribute;
import cdc.util.data.Child;
import cdc.util.data.Element;
import cdc.util.data.Node;
import cdc.util.data.Parent;
import cdc.util.data.Text;
import cdc.util.data.util.AttributeNameConverter;
import cdc.util.data.util.AttributePredicate;
import cdc.util.data.util.AttributeValueConverter;
import cdc.util.data.util.ElementNameConverter;
import cdc.util.data.util.TextContentConverter;
import cdc.util.data.util.TextPredicate;
import cdc.util.function.Evaluation;
import cdc.util.function.Evaluator;
import cdc.util.strings.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;

public final class DataUtil {
    public static final Comparator<Node> ELEMENT_NAME_COMPARATOR = (node1, node2) -> {
        if (node1 instanceof Element && node2 instanceof Element) {
            return ((Element)node1).getName().compareTo(((Element)node2).getName());
        }
        throw new IllegalArgumentException();
    };
    public static final Comparator<Node> ELEMENT_NAME_AND_ATTRIBUTES_COMPARATOR = (node1, node2) -> {
        if (node1 instanceof Element && node2 instanceof Element) {
            return DataUtil.getNameAndAttributes((Element)node1).compareTo(DataUtil.getNameAndAttributes((Element)node2));
        }
        throw new IllegalArgumentException();
    };
    public static final Evaluator<Node> RECURSE = Evaluator.continueTraversal();

    private DataUtil() {
    }

    private static String getNameAndAttributes(Element element) {
        StringBuilder builder = new StringBuilder();
        builder.append(element.getName());
        for (Attribute att : element.getSortedAttributes()) {
            builder.append(':');
            builder.append(att.getName());
            builder.append('=');
            builder.append(att.getValue());
        }
        return builder.toString();
    }

    public static void setNameOfMatchingAttributes(Parent parent, AttributePredicate predicate, AttributeNameConverter converter, Evaluator<? super Parent> evaluator) {
        if (parent instanceof Element) {
            Element element = (Element)parent;
            ArrayList<Attribute> atts = null;
            for (Attribute att : element.getAttributes()) {
                if (!predicate.accepts(element, att.getName(), att.getValue())) continue;
                if (atts == null) {
                    atts = new ArrayList<Attribute>();
                }
                atts.add(att);
            }
            if (atts != null) {
                for (Attribute att : atts) {
                    element.removeAttribute(att.getName());
                }
                for (Attribute att : atts) {
                    element.addAttribute(new Attribute(converter.convertAttributeName(element, att.getName())));
                }
            }
        }
        for (Parent child : parent.getChildren(Parent.class)) {
            if (evaluator.evaluate((Object)child) != Evaluation.CONTINUE) continue;
            DataUtil.setNameOfMatchingAttributes(child, predicate, converter, evaluator);
        }
    }

    public static void setNameOfMatchingAttributes(Parent parent, AttributePredicate predicate, Function<String, String> nameConverter, Evaluator<? super Parent> evaluator) {
        DataUtil.setNameOfMatchingAttributes(parent, predicate, AttributeNameConverter.fromFunction(nameConverter), evaluator);
    }

    public static void setValueOfMatchingAttributes(Parent parent, AttributePredicate predicate, AttributeValueConverter converter, Evaluator<? super Parent> evaluator) {
        if (parent instanceof Element) {
            Element element = (Element)parent;
            for (Attribute att : element.getAttributes()) {
                if (!predicate.accepts(element, att.getName(), att.getValue())) continue;
                String newValue = converter.convertAttributeValue(element, att.getName(), att.getValue());
                att.setValue(newValue);
            }
        }
        for (Parent child : parent.getChildren(Parent.class)) {
            if (evaluator.evaluate((Object)child) != Evaluation.CONTINUE) continue;
            DataUtil.setValueOfMatchingAttributes(child, predicate, converter, evaluator);
        }
    }

    public static void setValueOfMatchingAttributes(Parent parent, AttributePredicate predicate, Function<String, String> valueConverter, Evaluator<? super Parent> evaluator) {
        DataUtil.setValueOfMatchingAttributes(parent, predicate, AttributeValueConverter.fromFunction(valueConverter), evaluator);
    }

    public static void setValueOfMatchingAttributes(Parent parent, AttributePredicate predicate, String value, Evaluator<? super Parent> evaluator) {
        DataUtil.setValueOfMatchingAttributes(parent, predicate, (Element e, String n, String v) -> value, evaluator);
    }

    public static void scrambleValuesOfMatchingAttributes(Parent parent, AttributePredicate predicate, Evaluator<? super Parent> evaluator, boolean preserveSpaces) {
        DataUtil.setValueOfMatchingAttributes(parent, predicate, (Element e, String n, String v) -> StringUtil.scrambleWithLettersOrDigits((String)v, (boolean)preserveSpaces), evaluator);
    }

    public static void removeMatchingAttributes(Parent parent, AttributePredicate predicate, Evaluator<? super Parent> evaluator) {
        if (parent instanceof Element) {
            Element element = (Element)parent;
            Iterator<Attribute> atts = element.getAttributes().iterator();
            while (atts.hasNext()) {
                Attribute att = atts.next();
                if (!predicate.accepts(element, att.getName(), att.getValue())) continue;
                atts.remove();
            }
        }
        for (Parent child : parent.getChildren(Parent.class)) {
            if (evaluator.evaluate((Object)child) != Evaluation.CONTINUE) continue;
            DataUtil.removeMatchingAttributes(child, predicate, evaluator);
        }
    }

    public static void removeEmptyAttributes(Parent parent, Evaluator<? super Parent> evaluator) {
        DataUtil.removeMatchingAttributes(parent, AttributePredicate.IS_EMPTY_ATTRIBUTE, evaluator);
    }

    public static void sortAttributes(Parent parent, Comparator<Attribute> comparator, Evaluator<? super Parent> evaluator) {
        List<Attribute> atts;
        if (parent instanceof Element && (atts = ((Element)parent).getAttributes()).size() > 1) {
            Collections.sort(atts, comparator);
        }
        for (Parent child : parent.getChildren(Parent.class)) {
            if (evaluator.evaluate((Object)child) != Evaluation.CONTINUE) continue;
            DataUtil.sortAttributes(child, comparator, evaluator);
        }
    }

    public static void sortAttributesByName(Parent parent, Evaluator<? super Parent> evaluator) {
        DataUtil.sortAttributes(parent, Attribute.NAME_COMPARATOR, evaluator);
    }

    public static void moveAttributeFirst(Parent parent, Predicate<? super Element> predicate, String name, Evaluator<? super Parent> evaluator) {
        Attribute attribute;
        Element element;
        if (parent instanceof Element && predicate.test(element = (Element)parent) && element.getAttributesCount() > 1 && !element.getAttributeAt(0).getName().equals(name) && (attribute = element.removeAttribute(name)) != null) {
            element.getAttributes().add(0, attribute);
        }
        for (Parent child : parent.getChildren(Parent.class)) {
            if (evaluator.evaluate((Object)child) != Evaluation.CONTINUE) continue;
            DataUtil.moveAttributeFirst(child, predicate, name, evaluator);
        }
    }

    public static void setNameOfMatchingElements(Parent parent, Predicate<? super Element> predicate, ElementNameConverter converter, Evaluator<? super Parent> evaluator) {
        Element element;
        if (parent instanceof Element && predicate.test(element = (Element)parent)) {
            element.setName(converter.convertElementName(parent, element.getName()));
        }
        for (Parent child : parent.getChildren(Parent.class)) {
            if (evaluator.evaluate((Object)child) != Evaluation.CONTINUE) continue;
            DataUtil.setNameOfMatchingElements(child, predicate, converter, evaluator);
        }
    }

    public static void setNameOfMatchingElements(Parent parent, Predicate<? super Element> predicate, Function<String, String> nameConverter, Evaluator<? super Parent> evaluator) {
        DataUtil.setNameOfMatchingElements(parent, predicate, ElementNameConverter.fromFunction(nameConverter), evaluator);
    }

    public static void setContentOfMatchingTexts(Parent parent, TextPredicate predicate, TextContentConverter converter, Evaluator<? super Parent> evaluator) {
        for (Child child : parent.getChildren()) {
            if (child instanceof Text) {
                Text text = (Text)child;
                if (!predicate.accepts(parent, text)) continue;
                String content = converter.convertTextContent(parent, text.getContent());
                text.setContent(content);
                continue;
            }
            if (!(child instanceof Parent) || evaluator.evaluate((Object)((Parent)((Object)child))) != Evaluation.CONTINUE) continue;
            DataUtil.setContentOfMatchingTexts((Parent)((Object)child), predicate, converter, evaluator);
        }
    }

    public static void setContentOfMatchingTexts(Parent parent, TextPredicate predicate, Function<String, String> contentConverter, Evaluator<? super Parent> evaluator) {
        DataUtil.setContentOfMatchingTexts(parent, predicate, TextContentConverter.fromFunction(contentConverter), evaluator);
    }

    public static void scrambleContentOfMatchingTexts(Parent parent, TextPredicate predicate, Evaluator<? super Parent> evaluator, boolean preserveSpaces) {
        DataUtil.setContentOfMatchingTexts(parent, predicate, (String content) -> StringUtil.scrambleWithLettersOrDigits((String)content, (boolean)preserveSpaces), evaluator);
    }

    public static void removeMatchingChildren(Parent parent, Predicate<? super Child> predicate, Evaluator<? super Parent> evaluator) {
        for (Parent child : parent.getChildren(Parent.class)) {
            if (evaluator.evaluate((Object)child) != Evaluation.CONTINUE) continue;
            DataUtil.removeMatchingChildren(child, predicate, evaluator);
        }
        parent.removeChildren(predicate);
    }

    public static void removeComments(Parent parent, Evaluator<? super Parent> evaluator) {
        DataUtil.removeMatchingChildren(parent, Node.IS_COMMENT, evaluator);
    }

    public static void removeIgnorableText(Parent parent, Evaluator<? super Parent> evaluator) {
        DataUtil.removeMatchingChildren(parent, Node.IS_IGNORABLE_TEXT, evaluator);
    }

    public static void removeEmptyElements(Parent parent, Evaluator<? super Parent> evaluator) {
        DataUtil.removeMatchingChildren(parent, Node.IS_EMPTY_ELEMENT, evaluator);
    }

    public static void sortChildren(Parent parent, Predicate<? super Parent> predicate, Comparator<? super Child> comparator, Evaluator<? super Parent> evaluator) {
        if (predicate.test(parent) && parent.getChildren() != null) {
            parent.sortChildren(comparator);
            for (Parent child : parent.getChildren(Parent.class)) {
                if (evaluator.evaluate((Object)child) != Evaluation.CONTINUE) continue;
                DataUtil.sortChildren(child, predicate, comparator, evaluator);
            }
        }
    }

    public static void sortChildrenElementsByName(Parent parent, Predicate<? super Parent> predicate, Evaluator<? super Parent> evaluator) {
        DataUtil.sortChildren(parent, predicate, ELEMENT_NAME_COMPARATOR, evaluator);
    }

    public static void sortChildrenElementsByNameAndAttributes(Parent parent, Predicate<? super Parent> predicate, Evaluator<? super Parent> evaluator) {
        DataUtil.sortChildren(parent, predicate, ELEMENT_NAME_AND_ATTRIBUTES_COMPARATOR, evaluator);
    }

    public static boolean hasAncestorMatching(Node node, Predicate<Node> predicate) {
        Node index = node;
        while (index != null) {
            if (predicate.test(index)) {
                return true;
            }
            index = index instanceof Child ? ((Child)index).getParent() : null;
        }
        return false;
    }

    public static boolean hasDescendantMatching(Node node, Predicate<Node> predicate, boolean strict) {
        if (!strict && predicate.test(node)) {
            return true;
        }
        if (node instanceof Parent) {
            Parent parent = (Parent)node;
            for (Child child : parent.getChildren()) {
                if (!DataUtil.hasDescendantMatching(child, predicate, false)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasAllDescendantsMatching(Node node, Predicate<Node> predicate, boolean strict) {
        if (!strict && !predicate.test(node)) {
            return false;
        }
        if (node instanceof Parent) {
            Parent parent = (Parent)node;
            for (Child child : parent.getChildren()) {
                if (DataUtil.hasAllDescendantsMatching(child, predicate, false)) continue;
                return false;
            }
        }
        return true;
    }
}

