/*
 * Decompiled with CFR 0.152.
 */
package cdc.util.data.xml;

import cdc.util.data.Child;
import cdc.util.data.Comment;
import cdc.util.data.Document;
import cdc.util.data.Element;
import cdc.util.data.Parent;
import cdc.util.data.Text;
import cdc.util.data.util.AttributeNameConverter;
import cdc.util.data.util.AttributePredicate;
import cdc.util.data.util.AttributeValueConverter;
import cdc.util.data.util.ElementNameConverter;
import cdc.util.data.util.ElementPredicate;
import cdc.util.lang.Cache;
import cdc.util.lang.IntMasks;
import cdc.util.lang.UnexpectedValueException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DefaultHandler2;
import org.xml.sax.helpers.DefaultHandler;

public class XmlDataReader {
    public static final Cache<String> CACHE = new Cache(String.class, (s1, s2) -> s1.compareTo((String)s2));
    protected static final Logger LOGGER = LogManager.getLogger(XmlDataReader.class);
    private int features = 0;
    protected AttributePredicate attributeFilter = null;
    protected AttributeNameConverter attributeNameConverter = null;
    protected AttributeValueConverter attributeValueConverter = null;
    protected ElementPredicate elementFilter = null;
    protected ElementNameConverter elementNameConverter = null;

    public boolean isEnabled(Feature feature) {
        return IntMasks.isEnabled((int)this.features, (Enum)feature);
    }

    public void setEnabled(Feature feature, boolean enabled) {
        this.features = IntMasks.setEnabled((int)this.features, (Enum)feature, (boolean)enabled);
    }

    public AttributePredicate getAttributeFilter() {
        return this.attributeFilter;
    }

    public void setAttributeFilter(AttributePredicate filter) {
        this.attributeFilter = filter;
    }

    public AttributeNameConverter getAttributeNameConverter() {
        return this.attributeNameConverter;
    }

    public void setAttributeNameConverter(AttributeNameConverter converter) {
        this.attributeNameConverter = converter;
    }

    public AttributeValueConverter getAttributeValueConverter() {
        return this.attributeValueConverter;
    }

    public void setAttributeValueConverter(AttributeValueConverter converter) {
        this.attributeValueConverter = converter;
    }

    public ElementPredicate getElementFilter() {
        return this.elementFilter;
    }

    public void setElementFilter(ElementPredicate filter) {
        this.elementFilter = filter;
    }

    public ElementNameConverter getElementNameConverter() {
        return this.elementNameConverter;
    }

    public void setElementNameConverter(ElementNameConverter converter) {
        this.elementNameConverter = converter;
    }

    public Document read(InputStream is) throws IOException {
        LOGGER.debug("read(is=...)");
        SAXParserFactory factory = SAXParserFactory.newInstance();
        Handler handler = new Handler();
        try {
            SAXParser parser = factory.newSAXParser();
            if (this.isEnabled(Feature.LOAD_COMMENTS)) {
                XMLReader reader = parser.getXMLReader();
                reader.setProperty("http://xml.org/sax/properties/lexical-handler", handler);
            }
            parser.parse(is, (DefaultHandler)handler);
            return handler.getDocument();
        }
        catch (ParserConfigurationException e) {
            LOGGER.trace((Object)e);
        }
        catch (SAXException e) {
            throw new IOException(e);
        }
        return null;
    }

    public Element readRoot(InputStream is) throws IOException {
        return Document.getRootElement(this.read(is));
    }

    public Document read(InputStream is, String systemId) throws IOException {
        LOGGER.debug("read(is=..., " + systemId + ")");
        SAXParserFactory factory = SAXParserFactory.newInstance();
        Handler handler = new Handler();
        try {
            SAXParser parser = factory.newSAXParser();
            if (this.isEnabled(Feature.LOAD_COMMENTS)) {
                XMLReader reader = parser.getXMLReader();
                reader.setProperty("http://xml.org/sax/properties/lexical-handler", handler);
            }
            parser.parse(is, handler, systemId);
            return handler.getDocument();
        }
        catch (ParserConfigurationException e) {
            LOGGER.trace((Object)e);
        }
        catch (SAXException e) {
            throw new IOException(e);
        }
        return null;
    }

    public Element readRoot(InputStream is, String systemId) throws IOException {
        return Document.getRootElement(this.read(is, systemId));
    }

    public Document read(URL url) throws IOException {
        LOGGER.debug("read(url=" + url + ")");
        Throwable throwable = null;
        Object var3_4 = null;
        try (InputStream is = url.openStream();){
            return this.read(is);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public Element readRoot(URL url) throws IOException {
        return Document.getRootElement(this.read(url));
    }

    public Document read(String filename) throws IOException {
        LOGGER.debug("read(filename=" + filename + ")");
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileInputStream is = new FileInputStream(filename);){
            return this.read(is, filename);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public Element readRoot(String filename) throws IOException {
        return Document.getRootElement(this.read(filename));
    }

    public Document read(File file) throws IOException {
        LOGGER.debug("read(file=" + file + ")");
        return this.read(file.getPath());
    }

    public Element readRoot(File file) throws IOException {
        return Document.getRootElement(this.read(file));
    }

    public static XmlDataReader create(Feature ... features) {
        XmlDataReader reader = new XmlDataReader();
        Feature[] featureArray = features;
        int n = features.length;
        int n2 = 0;
        while (n2 < n) {
            Feature feature = featureArray[n2];
            reader.setEnabled(feature, true);
            ++n2;
        }
        return reader;
    }

    public static Document load(InputStream is, Feature ... features) throws IOException {
        XmlDataReader reader = XmlDataReader.create(features);
        return reader.read(is);
    }

    public static Element loadRoot(InputStream is, Feature ... features) throws IOException {
        XmlDataReader reader = XmlDataReader.create(features);
        return reader.readRoot(is);
    }

    public static Document load(InputStream is, String systemId, Feature ... features) throws IOException {
        XmlDataReader reader = XmlDataReader.create(features);
        return reader.read(is, systemId);
    }

    public static Element loadRoot(InputStream is, String systemId, Feature ... features) throws IOException {
        XmlDataReader reader = XmlDataReader.create(features);
        return reader.readRoot(is, systemId);
    }

    public static Document load(URL url, Feature ... features) throws IOException {
        XmlDataReader reader = XmlDataReader.create(features);
        return reader.read(url);
    }

    public static Element loadRoot(URL url, Feature ... features) throws IOException {
        XmlDataReader reader = XmlDataReader.create(features);
        return reader.readRoot(url);
    }

    public static Document load(String filename, Feature ... features) throws IOException {
        XmlDataReader reader = XmlDataReader.create(features);
        return reader.read(filename);
    }

    public static Element loadRoot(String filename, Feature ... features) throws IOException {
        XmlDataReader reader = XmlDataReader.create(features);
        return reader.readRoot(filename);
    }

    public static Document load(File file, Feature ... features) throws IOException {
        XmlDataReader reader = XmlDataReader.create(features);
        return reader.read(file);
    }

    public static Element loadRoot(File file, Feature ... features) throws IOException {
        XmlDataReader reader = XmlDataReader.create(features);
        return reader.readRoot(file);
    }

    private static enum Action {
        KEEP,
        IGNORE;

    }

    public static enum Feature {
        LOAD_COMMENTS,
        LOAD_SPACES,
        ALLOW_MIXED_CONTENT,
        SHARE_ATTRIBUTE_NAMES,
        SHARE_ELEMENT_NAMES;

    }

    private class Handler
    extends DefaultHandler2 {
        private Locator locator = null;
        private Document document = null;
        private Parent currentParent = null;
        private Text activeText = null;
        private final List<Action> actionStack = new ArrayList<Action>();

        private Action top() {
            if (this.actionStack.isEmpty()) {
                return Action.KEEP;
            }
            return this.actionStack.get(this.actionStack.size() - 1);
        }

        private void pushAction(Action action) {
            switch (this.top()) {
                case KEEP: {
                    this.actionStack.add(action);
                    break;
                }
                case IGNORE: {
                    this.actionStack.add(Action.IGNORE);
                    break;
                }
                default: {
                    throw new UnexpectedValueException((Enum)this.top());
                }
            }
        }

        private void popAction() {
            this.actionStack.remove(this.actionStack.size() - 1);
        }

        private void checkActiveText() throws SAXException {
            if (this.activeText != null) {
                if (this.activeText.getContent().isEmpty() || !XmlDataReader.this.isEnabled(Feature.LOAD_SPACES) && this.activeText.isIgnorable()) {
                    this.currentParent.removeChildAt(this.currentParent.getChildrenCount() - 1);
                    this.activeText = null;
                } else if (!XmlDataReader.this.isEnabled(Feature.ALLOW_MIXED_CONTENT) && this.currentParent.hasChildren(Element.class)) {
                    throw new SAXException("Mixed content not allowed");
                }
            }
        }

        public Document getDocument() {
            return this.document;
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        @Override
        public void startDocument() throws SAXException {
            LOGGER.trace("startDocument()");
            this.document = new Document();
            this.currentParent = this.document;
            this.activeText = null;
        }

        @Override
        public void endDocument() throws SAXException {
            LOGGER.trace("endDocument()");
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
        }

        @Override
        public void endPrefixMapping(String prefix) throws SAXException {
        }

        private final boolean acceptsAttribute(Element element, String name, String value) {
            return XmlDataReader.this.attributeFilter == null || XmlDataReader.this.attributeFilter.accepts(element, name, value);
        }

        private String shareAttributeName(String name) {
            if (XmlDataReader.this.isEnabled(Feature.SHARE_ATTRIBUTE_NAMES)) {
                return (String)CACHE.get((Object)name);
            }
            return name;
        }

        private final String convertAttributeName(Element element, String name) {
            if (XmlDataReader.this.attributeNameConverter == null) {
                return this.shareAttributeName(name);
            }
            return this.shareAttributeName(XmlDataReader.this.attributeNameConverter.convertAttributeName(element, name));
        }

        private final String convertAttributeValue(Element element, String name, String value) {
            return XmlDataReader.this.attributeValueConverter == null ? value : XmlDataReader.this.attributeValueConverter.convertAttributeValue(element, name, value);
        }

        private final boolean acceptsElement(Parent parent, Element element) {
            return XmlDataReader.this.elementFilter == null || XmlDataReader.this.elementFilter.accepts(parent, element);
        }

        private String shareElementName(String name) {
            if (XmlDataReader.this.isEnabled(Feature.SHARE_ELEMENT_NAMES)) {
                return (String)CACHE.get((Object)name);
            }
            return name;
        }

        private final String convertElementName(Parent parent, String name) {
            if (XmlDataReader.this.elementNameConverter == null) {
                return this.shareElementName(name);
            }
            return this.shareElementName(XmlDataReader.this.elementNameConverter.convertElementName(parent, name));
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            LOGGER.trace("startElement()");
            if (this.top() == Action.KEEP) {
                this.checkActiveText();
                if (!XmlDataReader.this.isEnabled(Feature.ALLOW_MIXED_CONTENT) && this.currentParent.hasChildren(Text.class)) {
                    throw new SAXException("Mixed content not allowed");
                }
                Element element = new Element(this.convertElementName(this.currentParent, qName));
                int index = 0;
                while (index < atts.getLength()) {
                    String value;
                    String name = atts.getQName(index);
                    if (this.acceptsAttribute(element, name, value = atts.getValue(index))) {
                        element.addAttribute(this.convertAttributeName(element, name), this.convertAttributeValue(element, name, value));
                    }
                    ++index;
                }
                if (this.acceptsElement(this.currentParent, element)) {
                    this.pushAction(Action.KEEP);
                    this.currentParent.addChild(element);
                    this.currentParent = element;
                    this.activeText = null;
                } else {
                    this.pushAction(Action.IGNORE);
                }
            } else {
                this.pushAction(Action.IGNORE);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            LOGGER.trace("endElement()");
            if (this.top() == Action.KEEP) {
                this.checkActiveText();
                this.currentParent = ((Child)((Object)this.currentParent)).getParent();
                this.activeText = null;
            }
            this.popAction();
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            LOGGER.trace("characters()");
            if (this.top() == Action.KEEP) {
                if (this.activeText == null) {
                    this.activeText = new Text();
                    this.currentParent.addChild(this.activeText);
                }
                this.activeText.appendContent(ch, start, length);
            }
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
            LOGGER.trace("ignorableWhitespace()");
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
        }

        @Override
        public void skippedEntity(String name) throws SAXException {
        }

        @Override
        public void startDTD(String name, String publicId, String systemId) throws SAXException {
        }

        @Override
        public void endDTD() throws SAXException {
        }

        @Override
        public void startEntity(String name) throws SAXException {
        }

        @Override
        public void endEntity(String name) throws SAXException {
        }

        @Override
        public void startCDATA() throws SAXException {
        }

        @Override
        public void endCDATA() throws SAXException {
        }

        @Override
        public void comment(char[] ch, int start, int length) throws SAXException {
            LOGGER.trace("comment()");
            if (this.top() == Action.KEEP) {
                this.checkActiveText();
                Comment comment = new Comment(new String(ch, start, length));
                this.currentParent.addChild(comment);
                this.activeText = null;
            }
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            LOGGER.warn(String.valueOf(this.locator.getLineNumber()) + ":" + this.locator.getColumnNumber(), (Throwable)exception);
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            LOGGER.error(String.valueOf(this.locator.getLineNumber()) + ":" + this.locator.getColumnNumber(), (Throwable)exception);
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            LOGGER.fatal(String.valueOf(this.locator.getLineNumber()) + ":" + this.locator.getColumnNumber(), (Throwable)exception);
            super.fatalError(exception);
        }
    }
}

