package cdc.demo.util.data;

import java.io.IOException;
import java.net.URL;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import cdc.util.data.Document;
import cdc.util.data.Element;
import cdc.util.data.xml.XmlDataWriter;
import cdc.util.debug.Debug;
import cdc.util.files.Resources;
import cdc.util.io.NonCloseableOutputStream;
import cdc.util.xml.XmlWriter;

public final class XmlDataWriterDemo {
    private static final Logger LOGGER = LogManager.getLogger(XmlDataWriterDemo.class);

    private XmlDataWriterDemo() {
    }

    public static void main(String[] args) throws IOException {
        LOGGER.info("Start " + XmlDataWriterDemo.class.getSimpleName());
        Debug.printClassPath();
        for (final URL url : Resources.getResources("log4j2.xml")) {
            LOGGER.info("   " + url);
        }
        final Document doc = new Document();
        final Element root = new Element("root");
        doc.addComment("Hello");
        doc.addChild(root);
        doc.addComment("Hello");
        root.addAttribute("att1", "value1");
        final Element child = new Element("child");
        child.addAttribute("att1", "value1");
        root.addChild(child);

        doc.removeChildren();
        doc.addComment("Hello");
        doc.addChild(root);
        doc.addComment("Hello");

        try (final XmlDataWriter writer = new XmlDataWriter(NonCloseableOutputStream.NON_CLOSABLE_SYSTEM_OUT)) {
            writer.getXmlWriter().setEnabled(XmlWriter.Feature.PRETTY_PRINT, true);
            writer.write(doc);
            writer.flush();
        }
    }
}