package cdc.test.util.data;

import static org.junit.jupiter.api.Assertions.assertEquals;

import java.util.Arrays;
import java.util.List;

import org.junit.jupiter.api.Test;

import cdc.util.data.paths.SPath;

public class SPathTest {

    private static void test(String text,
                             List<String> expectedParts,
                             boolean expectedAttribute) {
        final SPath path = new SPath(text);
        assertEquals(expectedAttribute, path.isAttribute());
        assertEquals(expectedParts, path.getParts());
    }

    @Test
    public void testConstructor() {
        test("hello", Arrays.asList("hello"), false);
        test("hello/world", Arrays.asList("hello", "world"), false);
        test("hello/world/how", Arrays.asList("hello", "world", "how"), false);
        test("@hello", Arrays.asList("hello"), true);
        test("hello@world", Arrays.asList("hello", "world"), true);
        test("hello/world@how", Arrays.asList("hello", "world", "how"), true);
    }
}