package cdc.util.data;

import java.util.Objects;

/**
 * Base class for nodes with content: text and comment.
 *
 * @author Damien Carbonne
 *
 */
abstract class AbstractContentNode extends AbstractChild implements Leaf {
    private final StringBuilder content = new StringBuilder();

    protected AbstractContentNode(Parent parent,
                                  String content) {
        super();
        setParent(parent);
        setContent(content);
    }

    public final void setContent(String content) {
        if (content != null) {
            this.content.setLength(0);
            this.content.append(content);
        }
    }

    public final void clearContent() {
        content.setLength(0);
    }

    public final void appendContent(String text) {
        if (text != null) {
            this.content.append(text);
        }
    }

    public final void appendContent(CharSequence cs,
                                    int start,
                                    int end) {
        content.append(cs, start, end);
    }

    public final void appendContent(char[] str,
                                    int offset,
                                    int len) {
        this.content.append(str, offset, len);
    }

    public final String getContent() {
        return content.toString();
    }

    @Override
    public final boolean deepEquals(Node node) {
        if (node == this) {
            return true;
        }
        if (node == null || !getClass().equals(node.getClass())) {
            return false;
        }
        final AbstractContentNode other = (AbstractContentNode) node;
        return Objects.equals(getContent(), other.getContent());
    }

}