package cdc.util.data;

/**
 * Comment node.
 * <p>
 * It has a text content and can be attached to a Document or Element.
 *
 * @author Damien Carbonne
 *
 */
public final class Comment extends AbstractContentNode {
    public Comment() {
        super(null, null);
    }

    public Comment(Parent parent) {
        super(parent, null);
    }

    public Comment(String content) {
        super(null, content);
    }

    public Comment(Parent parent,
                   String content) {
        super(parent, content);
    }

    public Comment(Comment other) {
        super(null, other.getContent());
    }

    @Override
    public NodeType getType() {
        return NodeType.COMMENT;
    }

    @Override
    public Comment clone(boolean recurse) {
        return new Comment(this);
    }

    @Override
    public String getQName() {
        return getParent().getQName() + "/comment()";
    }
}