/*
 * Decompiled with CFR 0.152.
 */
package cdc.test.util.data;

import cdc.util.data.Child;
import cdc.util.data.Comment;
import cdc.util.data.Document;
import cdc.util.data.Element;
import cdc.util.data.Node;
import cdc.util.data.NodeType;
import cdc.util.data.Parent;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class CommentTest {
    private static final String HELLO = "Hello";
    private static final String NAME = "name";

    CommentTest() {
    }

    @Test
    void testConstructors1() {
        Comment x = new Comment();
        Assertions.assertEquals((Object)NodeType.COMMENT, (Object)x.getType());
        Assertions.assertEquals(null, (Object)x.getParent());
        Assertions.assertEquals((Object)"", (Object)x.getContent());
        x.setContent(HELLO);
        Assertions.assertEquals((Object)HELLO, (Object)x.getContent());
        x.clearContent();
        Assertions.assertEquals((Object)"", (Object)x.getContent());
        x.appendContent(HELLO);
        Assertions.assertEquals((Object)HELLO, (Object)x.getContent());
        x.appendContent(null);
        Assertions.assertEquals((Object)HELLO, (Object)x.getContent());
        Assertions.assertEquals(null, (Object)x.getRootElement());
        Assertions.assertEquals(null, (Object)x.getDocument());
        Assertions.assertEquals((Object)x, (Object)x.getRootChild());
        Assertions.assertTrue((boolean)x.deepEquals((Node)x));
        Assertions.assertFalse((boolean)x.deepEquals(null));
    }

    @Test
    void testConstructors2() {
        Document doc = new Document();
        Comment x = new Comment((Parent)doc);
        Assertions.assertEquals((Object)NodeType.COMMENT, (Object)x.getType());
        Assertions.assertEquals((Object)doc, (Object)x.getParent());
        Assertions.assertEquals((Object)"", (Object)x.getContent());
        x.setContent(HELLO);
        Assertions.assertEquals((Object)HELLO, (Object)x.getContent());
        x.clearContent();
        Assertions.assertEquals((Object)"", (Object)x.getContent());
        x.appendContent(HELLO);
        Assertions.assertEquals((Object)HELLO, (Object)x.getContent());
        x.appendContent(null);
        Assertions.assertEquals((Object)HELLO, (Object)x.getContent());
        Assertions.assertEquals(null, (Object)x.getRootElement());
        Assertions.assertEquals((Object)doc, (Object)x.getDocument());
        Assertions.assertEquals((Object)x, (Object)x.getRootChild());
    }

    @Test
    void testClone() {
        Comment x1 = new Comment(null, HELLO);
        Comment x2 = x1.clone(false);
        Comment x3 = x1.clone(true);
        Assertions.assertNotEquals((Object)x1, (Object)x2);
        Assertions.assertNotEquals((Object)x1, (Object)x3);
        Assertions.assertTrue((boolean)x1.deepEquals((Node)x2));
        Assertions.assertTrue((boolean)x2.deepEquals((Node)x1));
    }

    @Test
    void testGetRootElement() {
        Comment x = new Comment(HELLO);
        Assertions.assertEquals(null, (Object)x.getRootElement());
        Element root = new Element(NAME);
        root.addChild((Child)x);
        Assertions.assertEquals((Object)root, (Object)x.getRootElement());
    }
}

