package cdc.util.data;

import cdc.util.xml.XmlUtils;

/**
 * Text node.
 * <p>
 * It has a text content and can be attached to a Document or Element.
 *
 * @author Damien Carbonne
 *
 */
public final class Text extends AbstractContentNode {
    public Text() {
        super(null, null);
    }

    public Text(Parent parent) {
        super(parent, null);
    }

    public Text(String content) {
        super(null, content);
    }

    public Text(Parent parent,
                String content) {
        super(parent, content);
    }

    public Text(Text other) {
        super(null, other.getContent());
    }

    @Override
    public NodeType getType() {
        return NodeType.TEXT;
    }

    @Override
    public Text clone(boolean recurse) {
        return new Text(this);
    }

    @Override
    public String getQName() {
        return getParent().getQName() + "/text()";
    }

    public boolean isIgnorable() {
        return XmlUtils.isWhiteSpace(getContent());
    }
}