/*
 * Decompiled with CFR 0.152.
 */
package cdc.test.util.data;

import cdc.util.data.Attribute;
import cdc.util.data.Document;
import cdc.util.data.Node;
import cdc.util.data.Parent;
import cdc.util.data.util.AttributeNameConverter;
import cdc.util.data.util.AttributePredicate;
import cdc.util.data.util.AttributeValueConverter;
import cdc.util.data.util.DataUtils;
import cdc.util.data.util.ElementNameConverter;
import cdc.util.data.util.TextContentConverter;
import cdc.util.data.util.TextPredicate;
import cdc.util.data.xml.XmlDataReader;
import cdc.util.data.xml.XmlDataWriter;
import cdc.util.function.Evaluator;
import cdc.util.function.Predicates;
import cdc.util.xml.XmlWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Comparator;
import java.util.function.Predicate;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class DataUtilsTest {
    private static final String XML = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    private static final String INDENT = null;
    private static final String EOL = "";

    DataUtilsTest() {
    }

    @Test
    void testSetNameOfMatchingAttributes() throws IOException {
        String source = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><root x='a'><child y='a'/></root>";
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><root X='a'><child Y='a'/></root>";
        Document doc = XmlDataReader.load((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><root x='a'><child y='a'/></root>", (Charset)StandardCharsets.UTF_8, (XmlDataReader.Feature[])new XmlDataReader.Feature[0]);
        DataUtils.setNameOfMatchingAttributes((Parent)doc, (AttributePredicate)AttributePredicate.ANY_ATTRIBUTE, (AttributeNameConverter)AttributeNameConverter.fromNameFunction(String::toUpperCase), (Evaluator)DataUtils.RECURSE);
        String target = XmlDataWriter.toString((Document)doc, (String)INDENT, (XmlWriter.Feature[])new XmlWriter.Feature[]{XmlWriter.Feature.USE_SINGLE_QUOTE});
        Assertions.assertEquals((Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><root X='a'><child Y='a'/></root>", (Object)target);
    }

    @Test
    void testSetValueOfMatchingAttributes() throws IOException {
        String source = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><root x='a'><child y='a'/></root>";
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><root x='A'><child y='A'/></root>";
        Document doc = XmlDataReader.load((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><root x='a'><child y='a'/></root>", (Charset)StandardCharsets.UTF_8, (XmlDataReader.Feature[])new XmlDataReader.Feature[0]);
        DataUtils.setValueOfMatchingAttributes((Parent)doc, (AttributePredicate)AttributePredicate.ANY_ATTRIBUTE, (AttributeValueConverter)AttributeValueConverter.fromValueFunction(String::toUpperCase), (Evaluator)DataUtils.RECURSE);
        String target = XmlDataWriter.toString((Document)doc, (String)INDENT, (XmlWriter.Feature[])new XmlWriter.Feature[]{XmlWriter.Feature.USE_SINGLE_QUOTE});
        Assertions.assertEquals((Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><root x='A'><child y='A'/></root>", (Object)target);
    }

    @Test
    void testSortAttributes() throws IOException {
        String source = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><root y='b' x='a'><child y='b' x='a'/></root>";
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><root x='a' y='b'><child x='a' y='b'/></root>";
        Document doc = XmlDataReader.load((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><root y='b' x='a'><child y='b' x='a'/></root>", (Charset)StandardCharsets.UTF_8, (XmlDataReader.Feature[])new XmlDataReader.Feature[0]);
        DataUtils.sortAttributes((Parent)doc, (Comparator)Attribute.NAME_COMPARATOR, (Evaluator)DataUtils.RECURSE);
        String target = XmlDataWriter.toString((Document)doc, (String)INDENT, (XmlWriter.Feature[])new XmlWriter.Feature[]{XmlWriter.Feature.USE_SINGLE_QUOTE});
        Assertions.assertEquals((Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><root x='a' y='b'><child x='a' y='b'/></root>", (Object)target);
    }

    @Test
    void testRemoveEmptyAttributes() throws IOException {
        String source = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><root x='' y='b'><child x='' y=''/></root>";
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><root y='b'><child/></root>";
        Document doc = XmlDataReader.load((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><root x='' y='b'><child x='' y=''/></root>", (Charset)StandardCharsets.UTF_8, (XmlDataReader.Feature[])new XmlDataReader.Feature[0]);
        DataUtils.removeEmptyAttributes((Parent)doc, (Evaluator)DataUtils.RECURSE);
        String target = XmlDataWriter.toString((Document)doc, (String)INDENT, (XmlWriter.Feature[])new XmlWriter.Feature[]{XmlWriter.Feature.USE_SINGLE_QUOTE});
        Assertions.assertEquals((Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><root y='b'><child/></root>", (Object)target);
    }

    @Test
    void testRemovePureElements() throws IOException {
        String source = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><root x='a'><child><child/><child/></child></root>";
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><root x='a'/>";
        Document doc = XmlDataReader.load((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><root x='a'><child><child/><child/></child></root>", (Charset)StandardCharsets.UTF_8, (XmlDataReader.Feature[])new XmlDataReader.Feature[0]);
        DataUtils.removePureElements((Parent)doc, (Evaluator)DataUtils.RECURSE);
        String target = XmlDataWriter.toString((Document)doc, (String)INDENT, (XmlWriter.Feature[])new XmlWriter.Feature[]{XmlWriter.Feature.USE_SINGLE_QUOTE});
        Assertions.assertEquals((Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><root x='a'/>", (Object)target);
    }

    @Test
    void testSetNameOfMatchingElements() throws IOException {
        String source = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><root x='a'><child x='a'/></root>";
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><ROOT x='a'><CHILD x='a'/></ROOT>";
        Document doc = XmlDataReader.load((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><root x='a'><child x='a'/></root>", (Charset)StandardCharsets.UTF_8, (XmlDataReader.Feature[])new XmlDataReader.Feature[0]);
        DataUtils.setNameOfMatchingElements((Parent)doc, (Predicate)Predicates.alwaysTrue(), (ElementNameConverter)ElementNameConverter.fromNameFunction(String::toUpperCase), (Evaluator)DataUtils.RECURSE);
        String target = XmlDataWriter.toString((Document)doc, (String)INDENT, (XmlWriter.Feature[])new XmlWriter.Feature[]{XmlWriter.Feature.USE_SINGLE_QUOTE});
        Assertions.assertEquals((Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><ROOT x='a'><CHILD x='a'/></ROOT>", (Object)target);
    }

    @Test
    void testSortChildrenElementsByName() throws IOException {
        String source = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><root x='a'><child2 x='a'/><child1 x='a'/></root>";
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><root x='a'><child1 x='a'/><child2 x='a'/></root>";
        Document doc = XmlDataReader.load((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><root x='a'><child2 x='a'/><child1 x='a'/></root>", (Charset)StandardCharsets.UTF_8, (XmlDataReader.Feature[])new XmlDataReader.Feature[0]);
        DataUtils.sortChildren((Parent)doc, (Predicate)Predicates.alwaysTrue(), (Comparator)Node.ELEMENT_NAME_COMPARATOR, (Evaluator)DataUtils.RECURSE);
        String target = XmlDataWriter.toString((Document)doc, (String)INDENT, (XmlWriter.Feature[])new XmlWriter.Feature[]{XmlWriter.Feature.USE_SINGLE_QUOTE});
        Assertions.assertEquals((Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><root x='a'><child1 x='a'/><child2 x='a'/></root>", (Object)target);
    }

    @Test
    void testSortChildrenElementsByNameAndAttributes() throws IOException {
        String source = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><root x='a'><child x='b'/><child x='a'/></root>";
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><root x='a'><child x='a'/><child x='b'/></root>";
        Document doc = XmlDataReader.load((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><root x='a'><child x='b'/><child x='a'/></root>", (Charset)StandardCharsets.UTF_8, (XmlDataReader.Feature[])new XmlDataReader.Feature[0]);
        DataUtils.sortChildren((Parent)doc, (Predicate)Predicates.alwaysTrue(), (Comparator)Node.ELEMENT_NAME_AND_ATTRIBUTES_COMPARATOR, (Evaluator)DataUtils.RECURSE);
        String target = XmlDataWriter.toString((Document)doc, (String)INDENT, (XmlWriter.Feature[])new XmlWriter.Feature[]{XmlWriter.Feature.USE_SINGLE_QUOTE});
        Assertions.assertEquals((Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><root x='a'><child x='a'/><child x='b'/></root>", (Object)target);
    }

    @Test
    void testSetContentOfMatchingTexts() throws IOException {
        String source = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><root x='a'><child y='a'>aaa</child></root>";
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><root x='a'><child y='a'>AAA</child></root>";
        Document doc = XmlDataReader.load((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><root x='a'><child y='a'>aaa</child></root>", (Charset)StandardCharsets.UTF_8, (XmlDataReader.Feature[])new XmlDataReader.Feature[0]);
        DataUtils.setContentOfMatchingTexts((Parent)doc, (TextPredicate)TextPredicate.ANY_TEXT, (TextContentConverter)TextContentConverter.fromContentFunction(String::toUpperCase), (Evaluator)DataUtils.RECURSE);
        String target = XmlDataWriter.toString((Document)doc, (String)INDENT, (XmlWriter.Feature[])new XmlWriter.Feature[]{XmlWriter.Feature.USE_SINGLE_QUOTE});
        Assertions.assertEquals((Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><root x='a'><child y='a'>AAA</child></root>", (Object)target);
    }
}

