/*
 * Decompiled with CFR 0.152.
 */
package cdc.test.util.data;

import cdc.util.data.Child;
import cdc.util.data.Comment;
import cdc.util.data.Document;
import cdc.util.data.Element;
import cdc.util.data.Node;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DocumentTest {
    static final String NAME = "name";
    private static final String VALUE = "value";

    @Test
    void testContructors() {
        Document doc = new Document();
        Assertions.assertEquals((Object)doc, (Object)doc.getDocument());
        Assertions.assertEquals(null, (Object)doc.getRootElement());
        Assertions.assertEquals((int)0, (int)doc.getChildrenCount());
        Assertions.assertTrue((boolean)doc.deepEquals((Node)doc));
        Assertions.assertEquals(null, (Object)doc.getLastChild());
    }

    @Test
    void testDeepEquals() {
        Document doc1 = new Document();
        Document doc2 = new Document();
        Assertions.assertTrue((boolean)doc1.deepEquals((Node)doc2));
        doc1.addChild((Child)new Comment());
        Assertions.assertFalse((boolean)doc1.deepEquals((Node)doc2));
        doc2.addChild((Child)new Comment());
        Assertions.assertTrue((boolean)doc1.deepEquals((Node)doc2));
        doc1.addChild((Child)new Element(NAME));
        Assertions.assertFalse((boolean)doc1.deepEquals((Node)doc2));
        doc2.addChild((Child)new Element(NAME));
        Assertions.assertTrue((boolean)doc1.deepEquals((Node)doc2));
        ((Element)doc1.getLastChild()).addAttribute(NAME, VALUE);
        Assertions.assertFalse((boolean)doc1.deepEquals((Node)doc2));
        ((Element)doc2.getLastChild()).addAttribute(NAME, VALUE);
        Assertions.assertTrue((boolean)doc1.deepEquals((Node)doc2));
        Document doc3 = doc1.clone(true);
        Assertions.assertTrue((boolean)doc1.deepEquals((Node)doc3));
        doc3.removeChildren();
        Assertions.assertEquals((int)0, (int)doc3.getChildrenCount());
    }

    @Test
    void testGetRootElement() {
        Assertions.assertEquals(null, (Object)Document.getRootElement(null));
        Document doc = new Document();
        Assertions.assertEquals(null, (Object)doc.getRootElement());
        Assertions.assertEquals(null, (Object)Document.getRootElement((Document)doc));
        Element root = new Element(NAME);
        doc.addChild((Child)root);
        Assertions.assertEquals((Object)root, (Object)doc.getRootElement());
        Assertions.assertEquals((Object)root, (Object)doc.getRootElement());
        Assertions.assertEquals((Object)root, (Object)Document.getRootElement((Document)doc));
    }

    @Test
    void testCanAddChild() {
        Document doc = new Document();
        Assertions.assertFalse((boolean)doc.canAddChild(null));
        Element root = doc.addElement("root");
        Assertions.assertFalse((boolean)doc.canAddChild((Child)root));
    }

    @Test
    void testRoot() {
        Document doc = new Document();
        Assertions.assertEquals(null, (Object)doc.getRootElement());
        Element root = new Element("root");
        Assertions.assertEquals(null, (Object)root.getParent());
        Assertions.assertTrue((boolean)doc.canAddChild((Child)root));
        doc.addChild((Child)root);
        Assertions.assertFalse((boolean)doc.canAddChild((Child)root));
        Assertions.assertEquals((Object)root, (Object)doc.getRootElement());
        root.setParent(null);
        Assertions.assertEquals(null, (Object)root.getParent());
        Assertions.assertEquals(null, (Object)doc.getRootElement());
    }
}

