/*
 * Decompiled with CFR 0.152.
 */
package cdc.test.util.data;

import cdc.util.data.Child;
import cdc.util.data.Comment;
import cdc.util.data.Element;
import cdc.util.data.Node;
import cdc.util.data.Text;
import cdc.util.data.xml.XmlDataWriter;
import cdc.util.function.IterableUtils;
import cdc.util.lang.ComparatorUtils;
import cdc.util.xml.XmlWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Comparator;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.io.IoBuilder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ParentTest {
    private static final Logger LOGGER = LogManager.getLogger(ParentTest.class);
    private static final PrintStream OUT = IoBuilder.forLogger((Logger)LOGGER).setLevel(Level.INFO).buildPrintStream();
    private static final String NAME = "name";
    private static final String NAME1 = "name1";
    private static final String NAME2 = "name2";
    private static final String VALUE = "value";

    ParentTest() {
    }

    protected static void print(Node node) {
        try {
            OUT.println("=====================");
            XmlDataWriter.print((Node)node, (boolean)false, (PrintStream)OUT, (String)"  ", (boolean)false, (XmlWriter.Feature[])new XmlWriter.Feature[]{XmlWriter.Feature.APPEND_FINAL_EOL});
            OUT.println();
        }
        catch (IOException e) {
            LOGGER.catching((Throwable)e);
        }
    }

    @Test
    void testGetChildren() {
        Element root = new Element(NAME);
        Assertions.assertEquals(null, (Object)root.getLastChild());
        Element child1 = root.addElement(NAME1);
        Element child2 = root.addElement(NAME2);
        Element child3 = root.addElement(NAME1);
        child3.addAttribute(NAME, VALUE);
        Comment child4 = root.addComment("Hello");
        Assertions.assertEquals((int)4, (int)root.getChildrenCount());
        Assertions.assertTrue((boolean)root.hasChildren(Element.class));
        Assertions.assertTrue((boolean)root.hasChildren(Comment.class));
        Assertions.assertFalse((boolean)root.hasChildren(Text.class));
        Assertions.assertEquals((Object)child4, (Object)root.getLastChild());
        Assertions.assertEquals((Object)child1, (Object)root.getChild(Element.class));
        Assertions.assertEquals((Object)child1, (Object)root.getElementNamed(NAME1));
        Assertions.assertEquals((int)3, (int)root.getChildrenCount(Element.class));
        Assertions.assertEquals((int)2, (int)root.getChildrenCount(Element.class, Element.named((String)NAME1)));
        Assertions.assertEquals((Object)child2, (Object)root.getChild(Element.class, Element.named((String)NAME2)));
        Assertions.assertEquals((Object)child2, (Object)root.getChildAt(Element.class, Element.named((String)NAME2), 0));
        Assertions.assertEquals(null, (Object)root.getChildAt(Element.class, Element.named((String)NAME2), 1));
        Assertions.assertEquals((Object)child3, (Object)root.getChildAt(2));
        Assertions.assertEquals((Object)child3, (Object)root.getChildAt(Element.class, 2));
        Assertions.assertEquals((Object)child4, (Object)root.getChildAt(Comment.class, 0));
        Assertions.assertEquals((int)3, (int)IterableUtils.size((Iterable)root.getElements()));
        Assertions.assertEquals((int)1, (int)IterableUtils.size((Iterable)root.getComments()));
        Assertions.assertEquals((int)0, (int)IterableUtils.size((Iterable)root.getTexts()));
        Assertions.assertEquals((Object)child3, (Object)root.getElementNamedWithAttribute(NAME1, NAME, VALUE));
    }

    @Test
    void testRemoveChildren() {
        Element root = new Element(NAME);
        Element child = root.addElement(NAME);
        root.removeChildren();
        Assertions.assertEquals((int)0, (int)root.getChildrenCount());
        Assertions.assertFalse((boolean)root.removeChild((Child)child));
        root.addElement(NAME);
        root.addComment("Hello");
        root.addElement(NAME);
        root.addText("World");
        root.addElement(NAME);
        root.removeComments();
        Assertions.assertEquals((int)4, (int)root.getChildrenCount());
        root.removeTexts();
        Assertions.assertEquals((int)3, (int)root.getChildrenCount());
        root.addElement(NAME1);
        root.removeElementsNamed(NAME);
        Assertions.assertEquals((int)1, (int)root.getChildrenCount());
    }

    @Test
    void testMerge() {
        Element root = new Element(NAME);
        root.addElement(NAME);
        root.addComment("Hello");
        Assertions.assertEquals((int)1, (int)root.getChildrenCount(Comment.class));
        root.addComment("World");
        Assertions.assertEquals((int)1, (int)root.getChildrenCount(Comment.class));
        root.addComment("Foo", false);
        Assertions.assertEquals((int)2, (int)root.getChildrenCount(Comment.class));
        root.mergeComments();
        Assertions.assertEquals((int)1, (int)root.getChildrenCount(Comment.class));
        root.removeChildren();
        root.addElement(NAME);
        root.addComment("Hello", false);
        root.addElement(NAME);
        root.addComment("Hello", false);
        root.addComment("Hello", false);
        root.addText("Hello", false);
        root.addComment("Hello", false);
        root.addComment("Hello", false);
        root.addText("Hello", false);
        root.addText("Hello", false);
        Assertions.assertEquals((int)5, (int)root.getChildrenCount(Comment.class));
        Assertions.assertEquals((int)3, (int)root.getChildrenCount(Text.class));
        root.mergeComments();
        Assertions.assertEquals((int)3, (int)root.getChildrenCount(Comment.class));
        Assertions.assertEquals((int)3, (int)root.getChildrenCount(Text.class));
        root.mergeTexts();
        Assertions.assertEquals((int)3, (int)root.getChildrenCount(Comment.class));
        Assertions.assertEquals((int)2, (int)root.getChildrenCount(Text.class));
        root.removeChildren();
        root.addComment("hello", false);
        root.addComment("hello", false);
        root.addText("Hello", false);
        root.addText("Hello", false);
        root.addComment("hello", false);
        root.addComment("hello", false);
        root.addText("Hello", false);
        root.addText("Hello", false);
        Element child = root.addElement("child");
        child.addComment("hello", false);
        child.addComment("hello", false);
        child.addText("Hello", false);
        child.addText("Hello", false);
        child.addComment("hello", false);
        child.addComment("hello", false);
        child.addText("Hello", false);
        child.addText("Hello", false);
        root.addComment("hello", false);
        root.addComment("hello", false);
        root.addText("Hello", false);
        root.addText("Hello", false);
        root.addComment("hello", false);
        root.addComment("hello", false);
        root.addText("Hello", false);
        root.addText("Hello", false);
        root.mergeComments(true);
        root.mergeTexts(true);
        Assertions.assertEquals((int)4, (int)root.getChildrenCount(Comment.class));
        Assertions.assertEquals((int)2, (int)child.getChildrenCount(Comment.class));
        Assertions.assertEquals((int)4, (int)root.getChildrenCount(Text.class));
        Assertions.assertEquals((int)2, (int)child.getChildrenCount(Text.class));
    }

    @Test
    void testChangeTexts() {
        Element root = new Element(NAME);
        root.addText("hello", false);
        root.addText("HELLO", false);
        root.changeTexts(String::toUpperCase);
        Assertions.assertEquals((int)2, (int)root.getChildrenCount());
        Assertions.assertEquals((Object)"HELLO", (Object)((Text)root.getChildAt(Text.class, 0)).getContent());
        Assertions.assertEquals((Object)"HELLO", (Object)((Text)root.getChildAt(Text.class, 1)).getContent());
        root.removeChildren();
        Element child1 = root.addElement(NAME1);
        Element child2 = root.addElement(NAME2);
        Element child3 = root.addElement(NAME1);
        child1.addText("hello");
        child2.addText("hello");
        child3.addText("hel");
        child3.addText("lo", false);
        Assertions.assertEquals((int)2, (int)child3.getChildrenCount());
        root.changeTexts(String::toUpperCase);
        Assertions.assertEquals((int)2, (int)child3.getChildrenCount());
        root.changeNamedTexts(NAME1, String::toUpperCase);
        Assertions.assertEquals((int)1, (int)child3.getChildrenCount());
        Assertions.assertEquals((Object)"HELLO", (Object)child1.getText());
        Assertions.assertEquals((Object)"HELLO", (Object)child3.getText());
    }

    @Test
    void testChangeComments() {
        Element root = new Element(NAME);
        root.addComment("hello", false);
        root.addComment("HELLO", false);
        root.changeComments(String::toUpperCase);
        Assertions.assertEquals((int)2, (int)root.getChildrenCount());
        Assertions.assertEquals((Object)"HELLO", (Object)((Comment)root.getChildAt(Comment.class, 0)).getContent());
        Assertions.assertEquals((Object)"HELLO", (Object)((Comment)root.getChildAt(Comment.class, 1)).getContent());
        root.removeChildren();
        Element child1 = root.addElement(NAME1);
        Element child2 = root.addElement(NAME2);
        Element child3 = root.addElement(NAME1);
        child1.addComment("hello");
        child2.addComment("hello");
        child3.addComment("hel");
        child3.addComment("lo", false);
        Assertions.assertEquals((int)2, (int)child3.getChildrenCount());
        root.changeComments(String::toUpperCase, true);
        Assertions.assertEquals((int)2, (int)child3.getChildrenCount());
        Assertions.assertEquals((Object)"HELLO", (Object)((Comment)child1.getChild(Comment.class)).getContent());
        Assertions.assertEquals((Object)"HEL", (Object)((Comment)child3.getChildAt(Comment.class, 0)).getContent());
    }

    @Test
    void testSortNoChildren() {
        Element root = new Element("root");
        root.sortChildren(ComparatorUtils.adapt(Element.class, (Comparator)Element.NAME_COMPARATOR));
    }

    @Test
    void testSortName() {
        Element root = new Element("root");
        for (int i = 9; i >= 0; --i) {
            root.addElement("child-" + i);
        }
        Assertions.assertEquals((Object)root.getElementNamed("child-0"), (Object)root.getChildAt(9));
        root.sortChildren(ComparatorUtils.adapt(Element.class, (Comparator)Element.NAME_COMPARATOR));
        Assertions.assertEquals((Object)root.getElementNamed("child-0"), (Object)root.getChildAt(0));
    }

    @Test
    void testSortAttribute() {
        Element root = new Element("root");
        for (int i = 9; i >= 0; --i) {
            Element child = root.addElement("child");
            child.addAttribute("id", i);
        }
        Assertions.assertEquals((Object)root.getElementNamedWithAttribute("child", "id", "0"), (Object)root.getChildAt(9));
        root.sortChildren(ComparatorUtils.adapt(Element.class, (Comparator)Element.compareAttribute((String)"id")));
        Assertions.assertEquals((Object)root.getElementNamedWithAttribute("child", "id", "0"), (Object)root.getChildAt(0));
    }
}

