/*
 * Decompiled with CFR 0.152.
 */
package cdc.test.util.data;

import cdc.util.data.Element;
import cdc.util.data.Parent;
import cdc.util.data.paths.SPath;
import java.util.Arrays;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class SPathTest {
    SPathTest() {
    }

    private static void testConstructor(String text, List<String> expectedParts, boolean expectedAttribute) {
        SPath path = new SPath(text);
        Assertions.assertEquals((Object)expectedAttribute, (Object)path.isAttribute());
        Assertions.assertEquals(expectedParts, (Object)path.getParts());
    }

    @Test
    void testConstructor() {
        SPathTest.testConstructor("hello", Arrays.asList("hello"), false);
        SPathTest.testConstructor("hello/world", Arrays.asList("hello", "world"), false);
        SPathTest.testConstructor("hello/world/how", Arrays.asList("hello", "world", "how"), false);
        SPathTest.testConstructor("@hello", Arrays.asList("hello"), true);
        SPathTest.testConstructor("hello@world", Arrays.asList("hello", "world"), true);
        SPathTest.testConstructor("hello/world@how", Arrays.asList("hello", "world", "how"), true);
    }

    private static void testElementMatches(String path, boolean expected, String ... names) {
        Element parent = null;
        for (String name : names) {
            parent = new Element(parent, name);
        }
        SPath spath = new SPath(path);
        Assertions.assertEquals((Object)expected, (Object)spath.matchesElement((Parent)parent));
    }

    @Test
    void testElementMatches() {
        SPathTest.testElementMatches("root", false, "ROOT");
        SPathTest.testElementMatches("root", true, "root");
        SPathTest.testElementMatches("child", true, "root", "child");
        SPathTest.testElementMatches("@child", false, "root", "child");
        SPathTest.testElementMatches("child", true, "root", "child", "child");
        SPathTest.testElementMatches("child/child", true, "root", "child", "child");
        SPathTest.testElementMatches("root/child", false, "root", "child", "child");
        SPathTest.testElementMatches("root/child/child", true, "root", "child", "child");
        SPathTest.testElementMatches("child", true, "root", "child");
        SPathTest.testElementMatches("child", true, "root", "child", "child");
        SPathTest.testElementMatches("child/child", true, "root", "child", "child");
        SPathTest.testElementMatches("child/child/child", false, "root", "child", "child");
    }

    private static void testAttributeMatches(String path, boolean expected, String ... names) {
        Element parent = null;
        for (String name : names) {
            parent = new Element((Parent)parent, name);
        }
        parent = (Element)parent.getParent();
        parent.addAttribute(names[names.length - 1], "");
        SPath spath = new SPath(path);
        Assertions.assertEquals((Object)expected, (Object)spath.matchesAttribute(parent, names[names.length - 1]));
    }

    @Test
    void testAttributeMatches() {
        SPathTest.testAttributeMatches("@att", true, "root", "att");
        SPathTest.testAttributeMatches("@att", false, "root", "att1");
        SPathTest.testAttributeMatches("@att", true, "root", "child", "att");
        SPathTest.testAttributeMatches("child@att", true, "root", "child", "att");
        SPathTest.testAttributeMatches("root/child@att", true, "root", "child", "att");
        SPathTest.testAttributeMatches("root/child@att", false, "root", "child", "att1");
    }
}

