/*
 * Decompiled with CFR 0.152.
 */
package cdc.test.util.data;

import cdc.util.data.Attribute;
import cdc.util.data.Comment;
import cdc.util.data.Document;
import cdc.util.data.Element;
import cdc.util.data.Node;
import cdc.util.data.Nodes;
import cdc.util.data.Text;
import cdc.util.data.util.DataStats;
import cdc.util.data.util.DataUtils;
import cdc.util.data.xml.XmlDataReader;
import cdc.util.data.xml.XmlDataWriter;
import cdc.util.debug.Memory;
import cdc.util.files.Files;
import cdc.util.time.Chronometer;
import cdc.util.xml.XmlWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.io.IoBuilder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class XmlDataReaderTest {
    private static final Logger LOGGER = LogManager.getLogger(XmlDataReaderTest.class);
    private static final PrintStream OUT = IoBuilder.forLogger((Logger)LOGGER).setLevel(Level.DEBUG).buildPrintStream();

    XmlDataReaderTest() {
    }

    private static void generateTestData(String filename) {
        try {
            int folders = 20;
            int objects = 500;
            int attributes = 100;
            XmlWriter writer = new XmlWriter(filename, "UTF-8");
            writer.setEnabled(XmlWriter.Feature.PRETTY_PRINT, true);
            writer.beginDocument();
            writer.beginElement("root");
            for (int findex = 0; findex < 20; ++findex) {
                writer.beginElement("folder");
                writer.addAttribute("type", "type" + findex);
                for (int oindex = 0; oindex < 500; ++oindex) {
                    writer.beginElement("object");
                    writer.addAttribute("id", findex + "." + oindex);
                    writer.addAttribute("type", "type" + findex);
                    for (int aindex = 0; aindex < 100; ++aindex) {
                        writer.beginElement("attribute");
                        writer.addAttribute("name", "att" + aindex);
                        writer.addAttribute("value", "value" + aindex);
                        writer.endElement();
                    }
                    writer.endElement();
                }
                writer.endElement();
            }
            writer.endElement();
            writer.endDocument();
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Test
    void testAttributeNameConversion() throws IOException {
        XmlDataReader reader = new XmlDataReader();
        reader.setEnabled(XmlDataReader.Feature.LOAD_SPACES, false);
        reader.setAttributeNameConverter((element, name) -> name.toUpperCase());
        URL url = this.getClass().getClassLoader().getResource("test-reader.xml");
        Document doc = reader.read(Files.toFile((URL)url).getPath());
        Assertions.assertTrue((boolean)DataUtils.hasAllDescendantsMatching((Node)doc, node -> {
            if (node instanceof Element) {
                Element e = (Element)node;
                for (Attribute a : e.getAttributes()) {
                    if (a.getName().toUpperCase().equals(a.getName())) continue;
                    return false;
                }
                return true;
            }
            return true;
        }, (boolean)true));
        LOGGER.debug("Upper case attribute names");
        XmlDataWriter.print((Document)doc, (PrintStream)OUT, (String)"  ", (boolean)false, (XmlWriter.Feature[])new XmlWriter.Feature[0]);
    }

    @Test
    void testAttributeValueConversion() throws IOException {
        XmlDataReader reader = new XmlDataReader();
        reader.setEnabled(XmlDataReader.Feature.LOAD_SPACES, false);
        reader.setAttributeValueConverter((element, name, value) -> value.toUpperCase());
        URL url = this.getClass().getClassLoader().getResource("test-reader.xml");
        Document doc = reader.read(Files.toFile((URL)url).getPath());
        LOGGER.debug("Upper case attribute values");
        XmlDataWriter.print((Document)doc, (PrintStream)OUT, (String)"  ", (boolean)false, (XmlWriter.Feature[])new XmlWriter.Feature[0]);
    }

    @Test
    void testAttributeFiltering() throws IOException {
        XmlDataReader reader = new XmlDataReader();
        reader.setEnabled(XmlDataReader.Feature.LOAD_SPACES, false);
        reader.setAttributeFilter((element, name, value) -> "id".equals(name));
        URL url = this.getClass().getClassLoader().getResource("test-reader.xml");
        Document doc = reader.read(Files.toFile((URL)url).getPath());
        LOGGER.debug("Only id attributes");
        XmlDataWriter.print((Document)doc, (PrintStream)OUT, (String)"  ", (boolean)false, (XmlWriter.Feature[])new XmlWriter.Feature[0]);
    }

    @Test
    void testElementNameConversion() throws IOException {
        XmlDataReader reader = new XmlDataReader();
        reader.setEnabled(XmlDataReader.Feature.LOAD_SPACES, false);
        reader.setElementNameConverter((parent, name) -> name.toUpperCase());
        URL url = this.getClass().getClassLoader().getResource("test-reader.xml");
        Document doc = reader.read(Files.toFile((URL)url).getPath());
        LOGGER.debug("Upper case element names");
        XmlDataWriter.print((Document)doc, (PrintStream)OUT, (String)"  ", (boolean)false, (XmlWriter.Feature[])new XmlWriter.Feature[0]);
    }

    @Test
    void testElementFiltering() throws IOException {
        XmlDataReader reader = new XmlDataReader();
        reader.setEnabled(XmlDataReader.Feature.LOAD_SPACES, false);
        reader.setElementPreFilter((parent, element) -> "root".equals(element.getName()) || "E1".equals(element.getAttributeValue("id", "")) || "E1.1".equals(element.getAttributeValue("id", "")) || "E2".equals(element.getAttributeValue("id", "")));
        URL url = this.getClass().getClassLoader().getResource("test-reader.xml");
        Document doc = reader.read(Files.toFile((URL)url).getPath());
        LOGGER.debug("Only E1, E1.1 and E2");
        XmlDataWriter.print((Document)doc, (PrintStream)OUT, (String)"  ", (boolean)false, (XmlWriter.Feature[])new XmlWriter.Feature[0]);
    }

    @Test
    void testLargeElementFiltering() throws IOException {
        File file = File.createTempFile("cdc-test", "xml");
        Chronometer chrono = new Chronometer();
        chrono.start();
        XmlDataReaderTest.generateTestData(file.getPath());
        chrono.suspend();
        LOGGER.debug("Generation time: {}", (Object)chrono);
        Memory.warmUp();
        Memory.runGC();
        long init = Memory.usedMemory();
        XmlDataReader reader = new XmlDataReader();
        reader.setEnabled(XmlDataReader.Feature.LOAD_SPACES, false);
        Predicate<Node> p = node -> {
            if (node instanceof Element) {
                Element e = (Element)node;
                return "folder".equals(e.getName()) && "type0".equals(e.getAttributeValue("type", ""));
            }
            return false;
        };
        reader.setElementPreFilter((parent, element) -> {
            boolean ok = "root".equals(element.getName()) || p.test((Node)element) || DataUtils.hasAncestorMatching((Node)parent, (Predicate)p);
            return ok;
        });
        chrono.start();
        Document doc = reader.read(file);
        Memory.runGC();
        long end = Memory.usedMemory();
        chrono.suspend();
        LOGGER.debug("Reading time: {} {}", (Object)chrono, (Object)(end - init));
        DataStats.print((Node)doc, (PrintStream)OUT, (int)0);
    }

    private static InputStream createInputStream(String s) {
        return new ByteArrayInputStream(s.getBytes());
    }

    private static void test(String expected, String source, Consumer<Document> docChecker, XmlDataReader.Feature ... features) throws IOException {
        LOGGER.debug("test({})", (Object)source);
        InputStream is = XmlDataReaderTest.createInputStream(source);
        Document doc = XmlDataReader.load((InputStream)is, (XmlDataReader.Feature[])features);
        if (docChecker != null) {
            docChecker.accept(doc);
        }
        String result = XmlDataWriter.toString((Document)doc, null, (XmlWriter.Feature[])new XmlWriter.Feature[]{XmlWriter.Feature.USE_XML_EOL});
        Assertions.assertEquals((Object)expected, (Object)result);
    }

    @Test
    void testFeaturesDefault0() throws IOException {
        XmlDataReaderTest.test("<?xml version=\"1.0\" encoding=\"UTF-8\"?><root/>", "<?xml version=\"1.0\" encoding=\"UTF-8\"?><!-- comment --><root/><!-- comment -->", doc -> {
            Assertions.assertEquals((int)1, (int)doc.getChildrenCount());
            Assertions.assertEquals((Object)"root", (Object)doc.getRootElement().getName());
            Assertions.assertEquals((int)0, (int)doc.getRootElement().getChildrenCount());
        }, new XmlDataReader.Feature[0]);
    }

    @Test
    void testFeaturesDefault1() throws IOException {
        XmlDataReaderTest.test("<?xml version=\"1.0\" encoding=\"UTF-8\"?><root/>", "<?xml version=\"1.0\" encoding=\"UTF-8\"?><!-- comment --><root></root><!-- comment -->", doc -> {
            Assertions.assertEquals((int)1, (int)doc.getChildrenCount());
            Assertions.assertEquals((Object)"root", (Object)doc.getRootElement().getName());
            Assertions.assertEquals((int)0, (int)doc.getRootElement().getChildrenCount());
        }, new XmlDataReader.Feature[0]);
    }

    @Test
    void testFeaturesDefault2() throws IOException {
        XmlDataReaderTest.test("<?xml version=\"1.0\" encoding=\"UTF-8\"?><root>   </root>", "<?xml version=\"1.0\" encoding=\"UTF-8\"?><!-- comment --><root> <!-- comment -->  </root><!-- comment -->", doc -> {
            Assertions.assertEquals((int)1, (int)doc.getChildrenCount());
            Assertions.assertEquals((Object)"root", (Object)doc.getRootElement().getName());
            Assertions.assertEquals((int)1, (int)doc.getRootElement().getChildrenCount());
        }, new XmlDataReader.Feature[0]);
    }

    @Test
    void testFeaturesDefault3() throws IOException {
        XmlDataReaderTest.test("<?xml version=\"1.0\" encoding=\"UTF-8\"?><root>aaa</root>", "<?xml version=\"1.0\" encoding=\"UTF-8\"?><!-- comment --><root><!-- comment -->aaa</root><!-- comment -->", doc -> {
            Assertions.assertEquals((int)1, (int)doc.getChildrenCount());
            Assertions.assertEquals((Object)"root", (Object)doc.getRootElement().getName());
            Assertions.assertEquals((int)1, (int)doc.getRootElement().getChildrenCount());
        }, new XmlDataReader.Feature[0]);
    }

    void testFeaturesDefaultUnexpectedMixed1() throws IOException {
        Assertions.assertThrows(IOException.class, () -> {
            InputStream is = XmlDataReaderTest.createInputStream("<?xml version=\"1.0\" encoding=\"UTF-8\"?><root>text<child/></root>");
            XmlDataReader.load((InputStream)is, (XmlDataReader.Feature[])new XmlDataReader.Feature[0]);
        });
    }

    void testFeaturesDefaultUnexpectedMixed2() throws IOException {
        Assertions.assertThrows(IOException.class, () -> {
            InputStream is = XmlDataReaderTest.createInputStream("<?xml version=\"1.0\" encoding=\"UTF-8\"?><root><child/>text</root>");
            XmlDataReader.load((InputStream)is, (XmlDataReader.Feature[])new XmlDataReader.Feature[0]);
        });
    }

    @Test
    void testFeaturesDefault4() throws IOException {
        XmlDataReaderTest.test("<?xml version=\"1.0\" encoding=\"UTF-8\"?><root><child> </child></root>", "<?xml version=\"1.0\" encoding=\"UTF-8\"?> \n  <root> \n <child> </child> \n </root>", doc -> {
            Assertions.assertEquals((int)1, (int)doc.getChildrenCount());
            Assertions.assertEquals((Object)"root", (Object)doc.getRootElement().getName());
            Assertions.assertEquals((int)1, (int)doc.getRootElement().getChildrenCount());
            Assertions.assertEquals((int)1, (int)((Element)doc.getRootElement().getChildAt(Element.class, 0)).getChildrenCount());
        }, new XmlDataReader.Feature[0]);
    }

    @Test
    void testFeaturesDefault5() throws IOException {
        XmlDataReaderTest.test("<?xml version=\"1.0\" encoding=\"UTF-8\"?><root><child/></root>", "<?xml version=\"1.0\" encoding=\"UTF-8\"?> \n  <root> \n <child></child> \n </root>", doc -> {
            Assertions.assertEquals((int)1, (int)doc.getChildrenCount());
            Assertions.assertEquals((Object)"root", (Object)doc.getRootElement().getName());
            Assertions.assertEquals((int)1, (int)doc.getRootElement().getChildrenCount());
            Assertions.assertEquals((int)0, (int)((Element)doc.getRootElement().getChildAt(Element.class, 0)).getChildrenCount());
        }, new XmlDataReader.Feature[0]);
    }

    @Test
    void testFeaturesDefault6() throws IOException {
        XmlDataReaderTest.test("<?xml version=\"1.0\" encoding=\"UTF-8\"?><root><child/></root>", "<?xml version=\"1.0\" encoding=\"UTF-8\"?><root><child/></root>", doc -> {
            Assertions.assertEquals((int)1, (int)doc.getChildrenCount());
            Assertions.assertEquals((Object)"root", (Object)doc.getRootElement().getName());
            Assertions.assertEquals((int)1, (int)doc.getRootElement().getChildrenCount());
        }, new XmlDataReader.Feature[0]);
    }

    @Test
    void testFeaturesDefault7() throws IOException {
        XmlDataReaderTest.test("<?xml version=\"1.0\" encoding=\"UTF-8\"?><root><child/></root>", "<?xml version=\"1.0\" encoding=\"UTF-8\"?> \n  <root> \n <child/> \n </root>", doc -> {
            Assertions.assertEquals((int)1, (int)doc.getChildrenCount());
            Assertions.assertEquals((Object)"root", (Object)doc.getRootElement().getName());
            Assertions.assertEquals((int)1, (int)doc.getRootElement().getChildrenCount());
        }, new XmlDataReader.Feature[0]);
    }

    @Test
    void testFeaturesComments() throws IOException {
        XmlDataReaderTest.test("<?xml version=\"1.0\" encoding=\"UTF-8\"?><!--comment--><root><child/></root>", "<?xml version=\"1.0\" encoding=\"UTF-8\"?> \n <!--comment--> <root> \n <child/> \n </root>", doc -> {
            Assertions.assertEquals((int)2, (int)doc.getChildrenCount());
            Assertions.assertEquals((int)1, (int)doc.getChildrenCount(Comment.class));
        }, XmlDataReader.Feature.LOAD_COMMENTS);
    }

    @Test
    void testFeaturesCommentsMixed1() throws IOException {
        XmlDataReaderTest.test("<?xml version=\"1.0\" encoding=\"UTF-8\"?><!--comment--><root>  aaa\n  aaa<child/>  aaa\n  aaa</root>", "<?xml version=\"1.0\" encoding=\"UTF-8\"?><!--comment--><root>  aaa\n  aaa<child/>  aaa\n  aaa</root>", doc -> {
            Assertions.assertEquals((int)2, (int)doc.getChildrenCount());
            Assertions.assertEquals((int)1, (int)doc.getChildrenCount(Comment.class));
            Assertions.assertEquals((int)3, (int)doc.getRootElement().getChildrenCount());
            Assertions.assertEquals((int)2, (int)doc.getRootElement().getChildrenCount(Text.class));
        }, XmlDataReader.Feature.LOAD_COMMENTS, XmlDataReader.Feature.LOAD_SPACES, XmlDataReader.Feature.ALLOW_MIXED_CONTENT);
    }

    @Test
    void testFeaturesCommentsMixed2() throws IOException {
        XmlDataReaderTest.test("<?xml version=\"1.0\" encoding=\"UTF-8\"?><!--comment--><root>aaa\naaa<child/>aaa\naaa</root>", "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!--comment--><root>aaa\naaa<child/>aaa\naaa</root>", doc -> {
            Nodes.print((Node)doc, (Logger)LOGGER, (Level)Level.DEBUG);
            Assertions.assertEquals((int)2, (int)doc.getChildrenCount());
            Assertions.assertEquals((int)1, (int)doc.getChildrenCount(Comment.class));
            Assertions.assertEquals((int)3, (int)doc.getRootElement().getChildrenCount());
            Assertions.assertEquals((int)2, (int)doc.getRootElement().getChildrenCount(Text.class));
        }, XmlDataReader.Feature.LOAD_COMMENTS, XmlDataReader.Feature.LOAD_SPACES, XmlDataReader.Feature.ALLOW_MIXED_CONTENT);
    }
}

