package cdc.util.graphs.impl;

import java.io.PrintStream;

import cdc.util.graphs.GraphAdapter;

/**
 * Utility class used to print a graph as text.
 * <p>
 * Mainly intended for debug purposes.
 *
 * @author Damien Carbonne
 */
public final class GraphPrinter {
    private GraphPrinter() {
    }

    /**
     * Print a graph (adapter) to an output stream.
     *
     * @param <N> Node class.
     * @param <E> Edge class.
     * @param adapter The graph adapter.
     * @param details If true, print detailed information.
     * @param out The stream to use.
     */
    public static <N, E> void print(GraphAdapter<N, E> adapter,
                                    boolean details,
                                    PrintStream out) {
        out.println("Nodes: " + adapter.getNodesCount() + " Edges: " + adapter.getEdgesCount());
        if (details) {
            for (final N node : adapter.getNodes()) {
                out.println("   " + node);
            }
            for (final E edge : adapter.getEdges()) {
                out.println("   " + edge);
            }
        }
    }
}