/*
 * Decompiled with CFR 0.152.
 */
package cdc.bench.util.graphs.impl;

import cdc.util.bench.BenchUtils;
import cdc.util.graphs.impl.BasicLightGraph;
import cdc.util.graphs.impl.BasicSuperLightGraph;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.results.format.ResultFormatType;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

@BenchmarkMode(value={Mode.Throughput})
@OutputTimeUnit(value=TimeUnit.SECONDS)
@State(value=Scope.Benchmark)
@Fork(value=1, jvmArgs={"-Xms1G", "-Xmx8G"})
@Warmup(iterations=5, time=100, timeUnit=TimeUnit.MILLISECONDS)
@Measurement(iterations=10, time=250, timeUnit=TimeUnit.MILLISECONDS)
public class GraphBuildingBench {
    @Param(value={"1000"})
    public int nodes;
    @Param(value={"10"})
    public int edges;
    @Param(value={"false", "true"})
    public boolean sorted;
    @Param(value={"false", "true"})
    public boolean checks;
    @Param(value={"SET", "LIST"})
    public BasicLightGraph.CollectionKind collectionKind;

    private static String n(int index) {
        return "N" + index;
    }

    @Benchmark
    public void benchString() {
        int i;
        BasicSuperLightGraph g = new BasicSuperLightGraph(this.sorted, this.collectionKind);
        g.setChecksEnabled(this.checks);
        for (i = 0; i < this.nodes; ++i) {
            g.addNode((Object)GraphBuildingBench.n(i));
        }
        for (i = 0; i < this.nodes - this.edges; ++i) {
            for (int j = 0; j < this.edges; ++j) {
                g.addEdge((Object)GraphBuildingBench.n(i), (Object)GraphBuildingBench.n(i + j));
            }
        }
    }

    @Benchmark
    public void benchInteger() {
        int i;
        BasicSuperLightGraph g = new BasicSuperLightGraph(this.sorted, this.collectionKind);
        g.setChecksEnabled(this.checks);
        for (i = 0; i < this.nodes; ++i) {
            g.addNode((Object)i);
        }
        for (i = 0; i < this.nodes - this.edges; ++i) {
            for (int j = 0; j < this.edges; ++j) {
                g.addEdge((Object)i, (Object)(i + j));
            }
        }
    }

    public static void main(String[] args) throws RunnerException {
        Options opt = new OptionsBuilder().include(GraphBuildingBench.class.getSimpleName()).resultFormat(ResultFormatType.CSV).result(BenchUtils.filename((String)"benchmarks", GraphBuildingBench.class, (String)".csv")).forks(1).build();
        new Runner(opt).run();
    }
}

