/*
 * Decompiled with CFR 0.152.
 */
package cdc.demo.util.graphs.impl;

import cdc.test.util.graphs.impl.TestGraphHeavyEdge;
import cdc.test.util.graphs.impl.TestGraphHeavyNode;
import cdc.test.util.graphs.impl.TestHeavyGraph;
import cdc.util.graphs.GraphAdapter;
import cdc.util.graphs.impl.GraphPrinter;
import cdc.util.graphs.impl.RestrictionSubGraph;
import java.io.PrintStream;

public final class SubGraphDemo {
    private SubGraphDemo() {
    }

    public static void main(String[] args) {
        TestHeavyGraph g = new TestHeavyGraph();
        TestGraphHeavyNode n1 = g.createNode("N1");
        TestGraphHeavyNode n2 = g.createNode("N2");
        TestGraphHeavyNode n3 = g.createNode("N3");
        TestGraphHeavyNode n4 = g.createNode("N4");
        TestGraphHeavyNode n5 = g.createNode("N5");
        TestGraphHeavyEdge e12 = g.createEdge("E12", n1, n2);
        g.createEdge("E21", n2, n1);
        g.createEdge("E13", n1, n3);
        g.createEdge("E34", n3, n4);
        TestGraphHeavyEdge e45 = g.createEdge("E45", n4, n5);
        g.createEdge("E54", n5, n4);
        System.out.println("---------------------------");
        System.out.println("Graph");
        GraphPrinter.print((GraphAdapter)g, (boolean)true, (PrintStream)System.out);
        RestrictionSubGraph sg = new RestrictionSubGraph((GraphAdapter)g);
        System.out.println("---------------------------");
        System.out.println("SubGraph (Should be the same as Graph)");
        GraphPrinter.print((GraphAdapter)sg, (boolean)true, (PrintStream)System.out);
        sg.clear();
        System.out.println("---------------------------");
        System.out.println("SubGraph (Should be empty)");
        GraphPrinter.print((GraphAdapter)sg, (boolean)true, (PrintStream)System.out);
        System.out.println("---------------------------");
        System.out.println("Graph");
        GraphPrinter.print((GraphAdapter)g, (boolean)true, (PrintStream)System.out);
        assert (!sg.containsNode((Object)n1));
        assert (!sg.containsEdge((Object)e45));
        sg.addNode((Object)n1);
        System.out.println("---------------------------");
        System.out.println("SubGraph (Should contain n1)");
        GraphPrinter.print((GraphAdapter)sg, (boolean)true, (PrintStream)System.out);
        sg.addEdge((Object)e12);
        sg.addEdge((Object)e45);
        System.out.println("---------------------------");
        System.out.println("SubGraph (Should contain n1,n2, n4 n5, e12 and e45)");
        GraphPrinter.print((GraphAdapter)sg, (boolean)true, (PrintStream)System.out);
        assert (sg.containsNode((Object)n1));
        assert (sg.containsEdge((Object)e45));
    }
}

