/*
 * Decompiled with CFR 0.152.
 */
package cdc.test.util.graphs.impl;

import cdc.test.util.graphs.impl.TestGraph;
import cdc.test.util.graphs.impl.TestGraphHeavyEdge;
import cdc.test.util.graphs.impl.TestGraphHeavyNode;
import cdc.util.graphs.impl.BasicGraphEdge;
import cdc.util.graphs.impl.BasicGraphHeavyNode;
import cdc.util.graphs.impl.BasicHeavyGraph;
import cdc.util.lang.Checks;
import java.util.HashMap;
import java.util.Map;

public final class TestHeavyGraph
extends BasicHeavyGraph<TestGraphHeavyNode, TestGraphHeavyEdge>
implements TestGraph<TestGraphHeavyNode, TestGraphHeavyEdge> {
    private final Map<String, TestGraphHeavyNode> nameToNode = new HashMap<String, TestGraphHeavyNode>();
    private final Map<String, TestGraphHeavyEdge> nameToEdge = new HashMap<String, TestGraphHeavyEdge>();

    @Override
    public void clear() {
        super.clear();
        this.nameToEdge.clear();
        this.nameToNode.clear();
    }

    @Override
    public TestGraphHeavyNode getNode(String name) {
        return this.nameToNode.get(name);
    }

    @Override
    public final TestGraphHeavyNode createNode(String name) {
        Checks.isFalse((boolean)this.hasNode(name), (String)"Duplicate node name: {}", (Object)name);
        TestGraphHeavyNode node = new TestGraphHeavyNode(name);
        this.addNode(node);
        this.nameToNode.put(name, node);
        return node;
    }

    @Override
    public void removeNode(TestGraphHeavyNode node) {
        Checks.isNotNull((Object)node, (String)"node");
        super.removeNode((BasicGraphHeavyNode)node);
        this.nameToNode.remove(node.getName());
    }

    @Override
    public TestGraphHeavyEdge getEdge(String name) {
        return this.nameToEdge.get(name);
    }

    @Override
    public final TestGraphHeavyEdge createEdge(String name, TestGraphHeavyNode source, TestGraphHeavyNode target) {
        Checks.isTrue((boolean)this.containsNode(source), (String)"Unknown source: {}", (Object)source);
        Checks.isTrue((boolean)this.containsNode(target), (String)"Unknown target: {}", (Object)target);
        Checks.isFalse((boolean)this.hasEdge(name), (String)"Duplicate edge name: {}", (Object)name);
        TestGraphHeavyEdge edge = new TestGraphHeavyEdge(name, source, target);
        this.addEdge(edge);
        this.nameToEdge.put(name, edge);
        return edge;
    }

    @Override
    public void removeEdge(TestGraphHeavyEdge edge) {
        Checks.isNotNull((Object)edge, (String)"edge");
        super.removeEdge((BasicGraphEdge)edge);
        this.nameToEdge.remove(edge.getName());
    }
}

