/*
 * Decompiled with CFR 0.152.
 */
package cdc.test.util.graphs.impl;

import cdc.test.util.graphs.impl.TestGraph;
import cdc.test.util.graphs.impl.TestGraphLightEdge;
import cdc.test.util.graphs.impl.TestGraphLightNode;
import cdc.util.graphs.GraphEdge;
import cdc.util.graphs.impl.BasicLightGraph;
import cdc.util.lang.Checks;
import java.util.HashMap;
import java.util.Map;

public class TestLighGraph
extends BasicLightGraph<TestGraphLightNode, TestGraphLightEdge>
implements TestGraph<TestGraphLightNode, TestGraphLightEdge> {
    private final Map<String, TestGraphLightNode> nameToNode = new HashMap<String, TestGraphLightNode>();
    private final Map<String, TestGraphLightEdge> nameToEdge = new HashMap<String, TestGraphLightEdge>();

    public TestLighGraph(boolean sorted) {
        super(sorted, BasicLightGraph.CollectionKind.LIST);
    }

    @Override
    public void clear() {
        super.clear();
        this.nameToEdge.clear();
        this.nameToNode.clear();
    }

    @Override
    public TestGraphLightNode getNode(String name) {
        return this.nameToNode.get(name);
    }

    @Override
    public final TestGraphLightNode createNode(String name) {
        Checks.isFalse((boolean)this.hasNode(name), (String)"Duplicate node name: {}", (Object)name);
        TestGraphLightNode node = new TestGraphLightNode(name);
        this.addNode(node);
        this.nameToNode.put(name, node);
        return node;
    }

    @Override
    public void removeNode(TestGraphLightNode node) {
        Checks.isNotNull((Object)node, (String)"node");
        super.removeNode((Object)node);
        this.nameToNode.remove(node.getName());
    }

    @Override
    public TestGraphLightEdge getEdge(String name) {
        return this.nameToEdge.get(name);
    }

    @Override
    public final TestGraphLightEdge createEdge(String name, TestGraphLightNode source, TestGraphLightNode target) {
        Checks.isTrue((boolean)this.containsNode(source), (String)"Unknown source: {}", (Object)source);
        Checks.isTrue((boolean)this.containsNode(target), (String)"Unknown target: {}", (Object)target);
        Checks.isFalse((boolean)this.hasEdge(name), (String)"Duplicate edge name: {}", (Object)name);
        TestGraphLightEdge edge = new TestGraphLightEdge(name, source, target);
        this.addEdge(edge);
        this.nameToEdge.put(name, edge);
        return edge;
    }

    @Override
    public void removeEdge(TestGraphLightEdge edge) {
        Checks.isNotNull((Object)edge, (String)"edge");
        super.removeEdge((GraphEdge)edge);
        this.nameToEdge.remove(edge.getName());
    }
}

