/*
 * Decompiled with CFR 0.152.
 */
package cdc.test.util.pstrings;

import cdc.util.pstrings.PackedString;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PackedStringTest {
    private static final Logger LOGGER = LogManager.getLogger(PackedStringTest.class);

    private static String build(String s, int count) {
        StringBuilder builder = new StringBuilder();
        for (int index = 0; index < count; ++index) {
            builder.append(s);
        }
        return builder.toString();
    }

    private static void checkConvert(String s) {
        LOGGER.debug("s: '" + s + "' " + (s == null ? "" : Integer.valueOf(s.length())));
        Object o1 = PackedString.convert((String)s);
        if (s == null) {
            Assertions.assertEquals(null, (Object)o1);
        } else {
            String s2 = o1.toString();
            Assertions.assertEquals((Object)s, (Object)s2);
        }
        Object o2 = PackedString.convert((String)s);
        Assertions.assertEquals((Object)o1, (Object)o2);
        if (o1 != null && o2 != null) {
            Assertions.assertEquals((int)o1.hashCode(), (int)o2.hashCode());
        }
    }

    private static void checkConvert(int n) {
        LOGGER.debug("c: [" + n + "] " + Character.charCount(n) + " '" + Character.getName(n) + "'");
        char c = (char)n;
        if (!Character.isSurrogate(c)) {
            String s = Character.toString(c);
            Object o = PackedString.convert((String)s);
            String s2 = o.toString();
            Assertions.assertEquals((Object)s, (Object)s2);
        }
    }

    @Test
    public void checkConvert() {
        int i;
        PackedStringTest.checkConvert(null);
        PackedStringTest.checkConvert("");
        PackedStringTest.checkConvert("a");
        PackedStringTest.checkConvert("\u00e0");
        for (i = 0; i < 128; ++i) {
            PackedStringTest.checkConvert(PackedStringTest.build("a", i));
            PackedStringTest.checkConvert(PackedStringTest.build("\u00e0", i));
        }
        for (i = 0; i <= 0x10FFFF; ++i) {
            PackedStringTest.checkConvert(i);
        }
    }
}

