/*
 * Decompiled with CFR 0.152.
 */
package cdc.util.pstrings;

import cdc.util.pstrings.PackedString16;
import cdc.util.pstrings.PackedString24;
import cdc.util.pstrings.PackedString32;
import cdc.util.pstrings.PackedString40;
import cdc.util.pstrings.PackedString48;
import cdc.util.pstrings.PackedString56;
import cdc.util.pstrings.PackedString64;
import cdc.util.pstrings.PackedString8;
import cdc.util.pstrings.PackedStringN;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class PackedString {
    private static final Logger LOGGER = LogManager.getLogger(PackedString.class);
    private static final CharsetEncoder ENCODER = StandardCharsets.UTF_8.newEncoder();
    private static final Map<PackedString, PackedString> POOL = new WeakHashMap<PackedString, PackedString>();

    protected static int get(byte[] bytes, int index) {
        return index < bytes.length ? bytes[index] & 0xFF : 0;
    }

    protected abstract byte[] toBytes();

    private static String toString(byte[] bytes) {
        int last;
        for (last = bytes.length - 1; last > 0 && bytes[last] == 0; --last) {
        }
        return new String(bytes, 0, last + 1, StandardCharsets.UTF_8);
    }

    PackedString intern() {
        PackedString value = POOL.get(this);
        if (value == null) {
            POOL.put(this, this);
            return this;
        }
        return value;
    }

    public static synchronized Object intern(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof PackedString) {
            return ((PackedString)o).intern();
        }
        if (o instanceof String) {
            return ((String)o).intern();
        }
        throw new IllegalArgumentException("Unexpected object class " + o.getClass().getCanonicalName());
    }

    public static Object convert(String s) {
        if (s == null) {
            return null;
        }
        if (s.length() == 0) {
            return "";
        }
        CharBuffer cbuffer = CharBuffer.wrap(s);
        try {
            ByteBuffer bbuffer = ENCODER.encode(cbuffer);
            byte[] bytes = bbuffer.array();
            int length = bbuffer.limit();
            if (length > 64) {
                return new PackedStringN(bytes);
            }
            if (length <= 8) {
                return new PackedString8(bytes).intern();
            }
            if (length <= 16) {
                return new PackedString16(bytes);
            }
            if (length <= 24) {
                return new PackedString24(bytes);
            }
            if (length <= 32) {
                return new PackedString32(bytes);
            }
            if (length <= 40) {
                return new PackedString40(bytes);
            }
            if (length <= 48) {
                return new PackedString48(bytes);
            }
            if (length <= 56) {
                return new PackedString56(bytes);
            }
            assert (length <= 64);
            return new PackedString64(bytes);
        }
        catch (CharacterCodingException e) {
            LOGGER.error("Failed to encode '" + s + "'", (Throwable)e);
            return s;
        }
    }

    public static Object convert(String s, boolean intern) {
        Object o = PackedString.convert(s);
        return intern ? PackedString.intern(o) : o;
    }

    public final String toString() {
        return PackedString.toString(this.toBytes());
    }
}

