/*
 * Decompiled with CFR 0.152.
 */
package cdc.test.util.validation;

import cdc.util.converters.Converter;
import cdc.util.converters.defaults.StringToInteger;
import cdc.util.validation.checkers.Checker;
import cdc.util.validation.checkers.defaults.IsInRange;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CheckerTest {
    private static final Logger LOGGER = LogManager.getLogger(CheckerTest.class);

    @Test
    public void testNegate() {
        Checker checker = IsInRange.from((int)0, (int)100).negate();
        Assertions.assertEquals((Object)true, (Object)checker.test((Object)200));
        LOGGER.debug(checker.explain());
    }

    @Test
    public void testAnd() {
        Checker checker = IsInRange.from((int)0, (int)100).and((Checker)IsInRange.from((int)50, (int)150));
        Assertions.assertEquals((Object)true, (Object)checker.test((Object)75));
        Assertions.assertEquals((Object)false, (Object)checker.test((Object)200));
        LOGGER.debug(checker.explain());
    }

    @Test
    public void testOr() {
        Checker checker = IsInRange.from((int)0, (int)100).or((Checker)IsInRange.from((int)50, (int)150));
        Assertions.assertEquals((Object)true, (Object)checker.test((Object)75));
        Assertions.assertEquals((Object)false, (Object)checker.test((Object)200));
        LOGGER.debug(checker.explain());
    }

    @Test
    public void testAfter() {
        Checker checker = IsInRange.from((int)10, (int)20).after((Converter)StringToInteger.INSTANCE);
        Assertions.assertEquals((Object)true, (Object)checker.test((Object)"15"));
        Assertions.assertEquals((Object)false, (Object)checker.test((Object)"30"));
        Assertions.assertEquals((Object)false, (Object)checker.test((Object)"Hello"));
        LOGGER.debug(checker.explain());
    }
}

