/*
 * Decompiled with CFR 0.152.
 */
package cdc.test.util.validation;

import cdc.util.validation.checkers.defaults.IsInRange;
import cdc.util.validation.checkers.defaults.IsInstanceOf;
import cdc.util.validation.checkers.defaults.IsNotNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CheckersDefaultTest {
    private static final Logger LOGGER = LogManager.getLogger(CheckersDefaultTest.class);

    @Test
    public void testIsNotNull() {
        Assertions.assertEquals((Object)false, (Object)IsNotNull.INSTANCE.test(null));
        Assertions.assertEquals((Object)true, (Object)IsNotNull.INSTANCE.test((Object)"Hello"));
        Assertions.assertEquals((Object)true, (Object)IsNotNull.INSTANCE.negate().test(null));
        Assertions.assertEquals((Object)false, (Object)IsNotNull.INSTANCE.negate().test((Object)"Hello"));
        LOGGER.debug(IsNotNull.INSTANCE.explain());
        LOGGER.debug(IsNotNull.INSTANCE.negate().explain());
        LOGGER.debug(IsNotNull.INSTANCE.testAndExplain(null));
        LOGGER.debug(IsNotNull.INSTANCE.testAndExplain((Object)"Hello"));
        LOGGER.debug(IsNotNull.INSTANCE.negate().testAndExplain(null));
        LOGGER.debug(IsNotNull.INSTANCE.negate().testAndExplain((Object)"Hello"));
    }

    @Test
    public void testIsInRange() {
        Assertions.assertEquals((Object)true, (Object)IsInRange.from((int)0, (int)100).test((Comparable)Integer.valueOf(10)));
        Assertions.assertEquals((Object)false, (Object)IsInRange.from((int)0, (int)100).test((Comparable)Integer.valueOf(200)));
        LOGGER.debug(IsInRange.from((int)0, (int)100).explain());
        LOGGER.debug(IsInRange.from((int)0, (int)100).negate().explain());
        LOGGER.debug(IsInRange.from((int)0, (int)100).testAndExplain((Object)10));
        LOGGER.debug(IsInRange.from((int)0, (int)100).testAndExplain((Object)200));
        LOGGER.debug(IsInRange.from((int)0, (int)100).negate().testAndExplain((Object)10));
        LOGGER.debug(IsInRange.from((int)0, (int)100).negate().testAndExplain((Object)200));
    }

    @Test
    public void testeIsInstanceOf() {
        IsInstanceOf checker = IsInstanceOf.from(String.class);
        Assertions.assertEquals((Object)false, (Object)checker.test(null));
        Assertions.assertEquals((Object)true, (Object)checker.test((Object)"Hello"));
        LOGGER.debug(checker.explain());
    }
}

