/*
 * Decompiled with CFR 0.152.
 */
package cdc.util.validation.checkers;

import cdc.util.lang.Checks;
import cdc.util.validation.checkers.Checker;
import java.util.function.Function;

final class CheckerSupport {
    static <S> Checker<S> fromFunctionUnchecked(final Function<S, ?> function, final Class<S> sourceClass, final Class<?> targetClass) {
        Checks.isNotNull(function, (String)"function");
        Checks.isNotNull(sourceClass, (String)"sourceClass");
        Checks.isNotNull(targetClass, (String)"targetClass");
        return new Checker<S>(){

            @Override
            public boolean test(S value) {
                try {
                    function.apply(value);
                    return true;
                }
                catch (Exception e) {
                    return false;
                }
            }

            @Override
            public Class<S> getValueClass() {
                return sourceClass;
            }

            @Override
            public String explain(boolean result, String arg) {
                if (result) {
                    return arg + " is convertible to " + targetClass.getCanonicalName();
                }
                return arg + " is not convertible to " + targetClass.getCanonicalName();
            }
        };
    }

    private CheckerSupport() {
    }
}

