/*
 * Decompiled with CFR 0.152.
 */
package cdc.util.validation.checkers;

import cdc.util.lang.FailureReaction;
import cdc.util.refs.ResolutionException;
import cdc.util.refs.ResolutionStatus;
import cdc.util.validation.checkers.Checker;
import cdc.util.validation.checkers.Checkers;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class RawRefChecker
implements Checker<Object> {
    private static final Logger LOGGER = LogManager.getLogger(RawRefChecker.class);
    private final String name;
    private ResolutionStatus status = ResolutionStatus.PENDING;
    private Checker<Object> delegate = null;

    public RawRefChecker(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void resolve(FailureReaction reaction) {
        if (this.status == ResolutionStatus.PENDING) {
            Checker<?> tmp = Checkers.getChecker(this.name, FailureReaction.FAIL);
            this.delegate = tmp;
            this.status = this.delegate == null ? ResolutionStatus.FAILURE : ResolutionStatus.SUCCESS;
        }
        if (this.status == ResolutionStatus.FAILURE) {
            if (reaction == FailureReaction.FAIL) {
                throw new ResolutionException("Failed to resolve " + this.name);
            }
            if (reaction == FailureReaction.WARN) {
                LOGGER.warn("Failed to resolve " + this.name);
            }
        }
    }

    public ResolutionStatus getResolutionStatus() {
        return this.status;
    }

    public Checker<?> getDelegate() {
        return this.delegate;
    }

    @Override
    public Class<Object> getValueClass() {
        this.resolve(FailureReaction.FAIL);
        return this.delegate.getValueClass();
    }

    @Override
    public boolean test(Object value) {
        this.resolve(FailureReaction.FAIL);
        Object tmp = this.delegate.getValueClass().cast(value);
        return this.delegate.test(tmp);
    }

    @Override
    public String explain(boolean result, String argName) {
        this.resolve(FailureReaction.FAIL);
        return this.delegate.explain(result, argName);
    }
}

