/*
 * Decompiled with CFR 0.152.
 */
package cdc.util.validation.checkers;

import cdc.util.lang.FailureReaction;
import cdc.util.refs.ResolutionException;
import cdc.util.refs.ResolutionStatus;
import cdc.util.validation.checkers.Checker;
import cdc.util.validation.checkers.Checkers;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class RefChecker<T>
implements Checker<T> {
    private static final Logger LOGGER = LogManager.getLogger(RefChecker.class);
    private final Class<T> valueClass;
    private final String name;
    private ResolutionStatus status = ResolutionStatus.PENDING;
    private Checker<? super T> delegate = null;

    public RefChecker(Class<T> valueClass, String name) {
        this.valueClass = valueClass;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void resolve(FailureReaction reaction) {
        if (this.status == ResolutionStatus.PENDING) {
            this.delegate = Checkers.getChecker(this.valueClass, this.name, FailureReaction.WARN);
            this.status = this.delegate == null ? ResolutionStatus.FAILURE : ResolutionStatus.SUCCESS;
        }
        if (this.status == ResolutionStatus.FAILURE) {
            if (reaction == FailureReaction.FAIL) {
                throw new ResolutionException("Failed to resolve " + this.name);
            }
            if (reaction == FailureReaction.WARN) {
                LOGGER.warn("Failed to resolve " + this.name);
            }
        }
    }

    public ResolutionStatus getResolutionStatus() {
        return this.status;
    }

    public Checker<? super T> getDelegate() {
        return this.delegate;
    }

    @Override
    public Class<T> getValueClass() {
        return this.valueClass;
    }

    @Override
    public boolean test(T value) {
        this.resolve(FailureReaction.FAIL);
        return this.delegate.test(value);
    }

    @Override
    public String explain(boolean result, String argName) {
        this.resolve(FailureReaction.FAIL);
        return this.delegate.explain(result, argName);
    }
}

