/*
 * Decompiled with CFR 0.152.
 */
package cdc.util.validation.checkers.defaults;

import cdc.util.args.AbstractFactory;
import cdc.util.args.Args;
import cdc.util.args.Factory;
import cdc.util.args.FormalArg;
import cdc.util.args.FormalArgs;
import cdc.util.args.Necessity;
import cdc.util.validation.checkers.defaults.AbstractStringChecker;

public class LengthIsInRange
extends AbstractStringChecker {
    private final int min;
    private final int max;
    public static final FormalArg<Integer> MIN = new FormalArg("min", Integer.class, Necessity.OPTIONAL);
    public static final FormalArg<Integer> MAX = new FormalArg("max", Integer.class, Necessity.OPTIONAL);
    public static final FormalArgs FARGS = new FormalArgs(new FormalArg[]{MIN, MAX});
    public static final Factory<LengthIsInRange> FACTORY = new AbstractFactory<LengthIsInRange>(LengthIsInRange.class, new FormalArgs[]{FARGS}){

        protected LengthIsInRange create(Args args, FormalArgs fargs) {
            return new LengthIsInRange((Integer)args.getValue(MIN, (Object)0), (Integer)args.getValue(MAX, (Object)Integer.MAX_VALUE));
        }
    };

    public LengthIsInRange(int min, int max) {
        this.min = min;
        this.max = max;
    }

    @Override
    public boolean test(String value) {
        return value != null && value.length() >= this.min && value.length() <= this.max;
    }

    @Override
    public String explain(boolean result, String arg) {
        if (result) {
            return arg + " length in [" + this.min + ".." + this.max + "]";
        }
        return arg + " length not in [" + this.min + ".." + this.max + "]";
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }
}

