/*
 * Decompiled with CFR 0.152.
 */
package cdc.util.validation.checkers.defaults;

import cdc.util.args.AbstractFactory;
import cdc.util.args.Args;
import cdc.util.args.Factory;
import cdc.util.args.FormalArg;
import cdc.util.args.FormalArgs;
import cdc.util.args.Necessity;
import cdc.util.lang.Checks;
import cdc.util.validation.checkers.defaults.AbstractStringChecker;
import java.util.regex.Pattern;

public final class MatchesPattern
extends AbstractStringChecker {
    private final Pattern pattern;
    public static final FormalArg<String> PATTERN = new FormalArg("pattern", String.class, Necessity.MANDATORY);
    public static final FormalArgs FARGS = new FormalArgs(new FormalArg[]{PATTERN});
    public static final Factory<MatchesPattern> FACTORY = new AbstractFactory<MatchesPattern>(MatchesPattern.class, new FormalArgs[]{FARGS}){

        protected MatchesPattern create(Args args, FormalArgs fargs) {
            return new MatchesPattern((String)args.getValue(PATTERN));
        }
    };
    public static final MatchesPattern LETTERS = new MatchesPattern("[A-Za-z]*");
    public static final MatchesPattern DIGITS = new MatchesPattern("[0-9]*");
    public static final MatchesPattern LETTERS_OR_DIGITS = new MatchesPattern("[A-Za-z0-9]*");
    public static final MatchesPattern UC_LETTERS = new MatchesPattern("[A-Z]*");
    public static final MatchesPattern UC_LETTERS_OR_DIGITS = new MatchesPattern("[A-Z0-9]*");
    public static final MatchesPattern LC_LETTERS = new MatchesPattern("[a-z]*");
    public static final MatchesPattern LC_LETTERS_OR_DIGITS = new MatchesPattern("[a-z0-9]*");

    public MatchesPattern(Pattern pattern) {
        Checks.isNotNull((Object)pattern, (String)"pattern");
        this.pattern = pattern;
    }

    public MatchesPattern(String regex) {
        this(Pattern.compile(regex));
    }

    @Override
    public boolean test(String value) {
        return value != null && this.pattern.matcher(value).matches();
    }

    @Override
    public String explain(boolean result, String argName) {
        if (result) {
            return argName + " matches '" + this.pattern.pattern() + "'";
        }
        return argName + " does not match '" + this.pattern.pattern() + "'";
    }

    public Pattern getPattern() {
        return this.pattern;
    }
}

