/*
 * Decompiled with CFR 0.152.
 */
package cdc.util.validation;

import cdc.util.debug.Printable;
import cdc.util.debug.Printables;
import cdc.util.lang.Checks;
import cdc.util.lang.CollectionUtils;
import cdc.util.lang.FailureReaction;
import cdc.util.lang.NotFoundException;
import cdc.util.validation.ValidationHandler;
import cdc.util.validation.ValidationRecord;
import cdc.util.validation.Validator;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Validators {
    private static final Logger LOGGER = LogManager.getLogger(Validators.class);
    public static final Printable PRINTER = new Printer();
    private static final Map<String, Validator<?>> MAP;

    private Validators() {
    }

    public static void register(Validator<?> validator, String name) {
        LOGGER.debug("register({}, {})", (Object)name, validator);
        Checks.isNotNullOrEmpty((String)name, (String)"name");
        Checks.isNotNull(validator, (String)"validator");
        if (MAP.containsKey(name)) {
            throw new IllegalArgumentException("A validator named '" + name + "' is already registered");
        }
        MAP.put(name, validator);
    }

    public static Set<String> getNames() {
        return MAP.keySet();
    }

    public static boolean hasValidator(String name) {
        return MAP.containsKey(name);
    }

    public static Validator<?> getValidator(String name, FailureReaction reaction) {
        return (Validator)NotFoundException.onResult(MAP.get(name), (String)("No '" + name + "' checker found"), (Logger)LOGGER, (FailureReaction)reaction, null);
    }

    public static Validator<?> getValidator(String name) {
        return Validators.getValidator(name, FailureReaction.FAIL);
    }

    public static <T> Validator<? super T> getValidator(Class<T> valueClass, String name, FailureReaction reaction) {
        Checks.isNotNull(valueClass, (String)"valueClass");
        Validator<?> tmp = Validators.getValidator(name, reaction);
        if (tmp != null && !tmp.getValueClass().isAssignableFrom(valueClass)) {
            throw new IllegalArgumentException("Non compliant class " + valueClass + " with " + tmp.getValueClass());
        }
        return tmp;
    }

    public static <T> Validator<? super T> getValidator(Class<T> valueClass, String name) {
        return Validators.getValidator(valueClass, name, FailureReaction.FAIL);
    }

    public static Validator<? super String> getStringValidator(String name, FailureReaction reaction) {
        return Validators.getValidator(String.class, name, reaction);
    }

    public static Validator<? super String> getStringValidator(String name) {
        return Validators.getValidator(String.class, name);
    }

    public static <T> void validate(Class<T> valueClass, String validatorName, FailureReaction reaction, T value, String valueName, ValidationHandler handler) {
        Validator<T> validator = Validators.getValidator(valueClass, validatorName, reaction);
        if (validator != null) {
            validator.validate(value, valueName, handler);
        }
    }

    public static <T> void validate(Class<T> valueClass, String validatorName, FailureReaction reaction, T value, String valueName, List<ValidationRecord> records) {
        Validator<T> validator = Validators.getValidator(valueClass, validatorName, reaction);
        if (validator != null) {
            validator.validate(value, valueName, records);
        }
    }

    public static <T> List<ValidationRecord> validate(Class<T> valueClass, String validatorName, FailureReaction reaction, T value, String valueName) {
        Validator<T> validator = Validators.getValidator(valueClass, validatorName, reaction);
        ArrayList<ValidationRecord> records = new ArrayList<ValidationRecord>();
        if (validator != null) {
            validator.validate(value, valueName, records);
        }
        return records;
    }

    public static void validateRaw(String validatorName, FailureReaction reaction, Object value, String valueName, ValidationHandler handler) {
        Validator<?> validator = Validators.getValidator(validatorName, reaction);
        if (validator != null) {
            validator.validateRaw(value, valueName, handler);
        }
    }

    public static void validateRaw(String validatorName, FailureReaction reaction, Object value, String valueName, List<ValidationRecord> records) {
        Validator<?> validator = Validators.getValidator(validatorName, reaction);
        if (validator != null) {
            validator.validateRaw(value, valueName, records);
        }
    }

    public static List<ValidationRecord> validatRaw(String validatorName, FailureReaction reaction, Object value, String valueName) {
        Validator<?> validator = Validators.getValidator(validatorName, reaction);
        ArrayList<ValidationRecord> records = new ArrayList<ValidationRecord>();
        if (validator != null) {
            validator.validateRaw(value, valueName, records);
        }
        return records;
    }

    static {
        Printables.register(Validators.class, (Printable)PRINTER);
        MAP = new HashMap();
    }

    protected static class Printer
    implements Printable {
        protected Printer() {
        }

        public void print(PrintStream out, int level) {
            this.indent(out, level);
            out.println("Validators (" + Validators.getNames().size() + ")");
            for (String name : CollectionUtils.toSortedList(Validators.getNames())) {
                Validator<?> validator = Validators.getValidator(name);
                this.indent(out, level + 1);
                out.println(validator.getValueClass());
                this.indent(out, level + 2);
                String error = validator.explainError("'value'");
                out.println("error: " + (error == null ? "" : error));
                this.indent(out, level + 2);
                String warning = validator.explainWarning("'value'");
                out.println("warning: " + (warning == null ? "" : warning));
            }
        }
    }
}

