/*
 * Decompiled with CFR 0.152.
 */
package cdc.util.validation.checkers.defaults;

import cdc.util.args.AbstractFactory;
import cdc.util.args.Args;
import cdc.util.args.Factory;
import cdc.util.args.FormalArg;
import cdc.util.args.FormalArgs;
import cdc.util.args.Necessity;
import cdc.util.converters.ConversionException;
import cdc.util.converters.Converter;
import cdc.util.converters.Converters;
import cdc.util.converters.defaults.StringToBoolean;
import cdc.util.converters.defaults.StringToByte;
import cdc.util.converters.defaults.StringToDouble;
import cdc.util.converters.defaults.StringToFloat;
import cdc.util.converters.defaults.StringToInteger;
import cdc.util.converters.defaults.StringToLong;
import cdc.util.converters.defaults.StringToShort;
import cdc.util.lang.Introspection;
import cdc.util.validation.checkers.Checker;

public class IsConvertibleUsing<T>
implements Checker<T> {
    private final Converter<T, ?> converter;
    public static final FormalArg<Converter<?, ?>> CONVERTER = new FormalArg("converter", Introspection.uncheckedCast(Converter.class), Necessity.MANDATORY);
    public static final FormalArgs FARGS1 = new FormalArgs(new FormalArg[]{CONVERTER});
    public static final FormalArg<String> NAME = new FormalArg("converter", String.class, Necessity.MANDATORY);
    public static final FormalArgs FARGS2 = new FormalArgs(new FormalArg[]{NAME});
    public static final Factory<IsConvertibleUsing> FACTORY = new AbstractFactory<IsConvertibleUsing>(IsConvertibleUsing.class, new FormalArgs[]{FARGS1, FARGS2}){

        protected IsConvertibleUsing create(Args args, FormalArgs fargs) {
            if (fargs.equals((Object)FARGS1)) {
                Converter rconverter = (Converter)args.getValue(CONVERTER);
                Converter tmp = (Converter)Converter.class.cast(rconverter);
                return new IsConvertibleUsing(tmp);
            }
            if (fargs.equals((Object)FARGS2)) {
                String name = (String)args.getValue(NAME);
                Converter rconverter = Converters.getConverter((String)name);
                Converter tmp = (Converter)Converter.class.cast(rconverter);
                return new IsConvertibleUsing(tmp);
            }
            throw new IllegalArgumentException();
        }
    };
    public static final IsConvertibleUsing<String> STRING_IS_DOUBLE = new IsConvertibleUsing(StringToDouble.INSTANCE);
    public static final IsConvertibleUsing<String> STRING_IS_FLOAT = new IsConvertibleUsing(StringToFloat.INSTANCE);
    public static final IsConvertibleUsing<String> STRING_IS_LONG = new IsConvertibleUsing(StringToLong.INSTANCE);
    public static final IsConvertibleUsing<String> STRING_IS_INTEGER = new IsConvertibleUsing(StringToInteger.INSTANCE);
    public static final IsConvertibleUsing<String> STRING_IS_SHORT = new IsConvertibleUsing(StringToShort.INSTANCE);
    public static final IsConvertibleUsing<String> STRING_IS_BYTE = new IsConvertibleUsing(StringToByte.INSTANCE);
    public static final IsConvertibleUsing<String> STRING_IS_BOOLEAN = new IsConvertibleUsing(StringToBoolean.INSTANCE);

    public IsConvertibleUsing(Converter<T, ?> converter) {
        this.converter = converter;
    }

    @Override
    public Class<T> getValueClass() {
        return this.converter.getSourceClass();
    }

    @Override
    public boolean test(T value) {
        try {
            this.converter.apply(value);
            return true;
        }
        catch (ConversionException e) {
            return false;
        }
    }

    @Override
    public String explain(boolean result, String arg) {
        if (result) {
            return this.wrap(arg) + " is convertible to " + this.converter.getTargetClass().getSimpleName();
        }
        return this.wrap(arg) + " is not convertible to " + this.converter.getTargetClass().getSimpleName();
    }
}

