/*
 * Decompiled with CFR 0.152.
 */
package cdc.util.validation.checkers.defaults;

import cdc.util.args.AbstractFactory;
import cdc.util.args.Args;
import cdc.util.args.Factory;
import cdc.util.args.FormalArg;
import cdc.util.args.FormalArgs;
import cdc.util.validation.checkers.Checker;
import cdc.util.validation.checkers.defaults.ComparablesSupport;

public class IsGreaterOrEqual<T extends Comparable<T>>
implements Checker<T> {
    private final Class<T> valueClass;
    private final T min;
    public static final FormalArg<Class> CLASS = ComparablesSupport.CLASS;
    public static final FormalArg<String> SMIN = ComparablesSupport.MANDATORY_STRING_MIN;
    public static final FormalArg<Comparable> CMIN = ComparablesSupport.MANDATORY_COMPARABLE_MIN;
    public static final FormalArgs SFARGS = new FormalArgs(new FormalArg[]{CLASS, SMIN});
    public static final FormalArgs CFARGS = new FormalArgs(new FormalArg[]{CLASS, CMIN});
    public static final Factory<IsGreaterOrEqual> FACTORY = new AbstractFactory<IsGreaterOrEqual>(IsGreaterOrEqual.class, new FormalArgs[]{SFARGS, CFARGS}){

        protected IsGreaterOrEqual<?> create(Args args, FormalArgs fargs) {
            if (fargs.equals((Object)SFARGS)) {
                Class<Comparable> cls = ComparablesSupport.getClass(args);
                Comparable minValue = ComparablesSupport.getMinFromString(args, cls);
                return new IsGreaterOrEqual<Comparable>(cls, minValue);
            }
            if (fargs.equals((Object)CFARGS)) {
                Class<Comparable> cls = ComparablesSupport.getClass(args);
                Comparable minValue = ComparablesSupport.getMinFromComparable(args, cls);
                return new IsGreaterOrEqual<Comparable>(cls, minValue);
            }
            throw new IllegalArgumentException();
        }
    };

    public IsGreaterOrEqual(Class<T> valueClass, T min) {
        this.valueClass = valueClass;
        this.min = min;
    }

    @Override
    public Class<T> getValueClass() {
        return this.valueClass;
    }

    @Override
    public boolean test(T value) {
        return value != null && value.compareTo(this.min) >= 0;
    }

    @Override
    public String explain(boolean result, String arg) {
        if (result) {
            return this.wrap(arg) + ">=" + this.min + ComparablesSupport.valueInfo(arg, this);
        }
        return this.wrap(arg) + "<" + this.min + ComparablesSupport.valueInfo(arg, this);
    }

    public T getMin() {
        return this.min;
    }

    public static IsGreaterOrEqual<String> from(String min) {
        return new IsGreaterOrEqual<String>(String.class, min);
    }

    public static IsGreaterOrEqual<Character> from(char min) {
        return new IsGreaterOrEqual<Character>(Character.class, Character.valueOf(min));
    }

    public static IsGreaterOrEqual<Double> from(double min) {
        return new IsGreaterOrEqual<Double>(Double.class, min);
    }

    public static IsGreaterOrEqual<Float> from(float min) {
        return new IsGreaterOrEqual<Float>(Float.class, Float.valueOf(min));
    }

    public static IsGreaterOrEqual<Long> from(long min) {
        return new IsGreaterOrEqual<Long>(Long.class, min);
    }

    public static IsGreaterOrEqual<Integer> from(int min) {
        return new IsGreaterOrEqual<Integer>(Integer.class, min);
    }

    public static IsGreaterOrEqual<Short> from(short min) {
        return new IsGreaterOrEqual<Short>(Short.class, min);
    }

    public static IsGreaterOrEqual<Byte> from(byte min) {
        return new IsGreaterOrEqual<Byte>(Byte.class, min);
    }
}

